package com.atlassian.bitbucket.event.content;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.event.branch.BranchChangeRequestedEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.InputSupplier;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.io.InputStream;
import java.util.Optional;

import static java.util.Objects.requireNonNull;
import static java.util.Optional.ofNullable;

/**
 * An event that is raised just before a file is edited on the server.
 * <p>
 * This event is {@link CancelableEvent cancelable}. A listener may prevent the file from being edited by
 * {@link #cancel(KeyedMessage) canceling} this event. Throwing an exception <i>will not</i> prevent the file
 * from being edited; the exception will be logged and ignored.
 *
 * @since 4.13
 * @deprecated since 5.0 for removal in 6.0. Listeners for {@code FileEditRequestedEvent} should implement a
 *             {@code PreRepositoryHook<EditFileHookRequest>} instead.
 */
@Deprecated
public class FileEditRequestedEvent extends BranchChangeRequestedEvent {

    private final InputSupplier<InputStream> content;
    private final String message;
    private final String path;

    public FileEditRequestedEvent(@Nonnull Object source, @Nonnull Repository repository,
                                  @Nonnull CancelState cancelState, @Nonnull Branch branch,
                                  @Nonnull String path, @Nonnull InputSupplier<InputStream> content,
                                  @Nullable String message) {
        super(source, repository, cancelState, branch);

        this.content = requireNonNull(content, "content");
        this.message = message;
        this.path = requireNonNull(path, "path");
    }

    /**
     * @return the new content of the edited file
     * @since 5.0
     */
    @Nonnull
    public InputSupplier<InputStream> getContent() {
        return content;
    }

    /**
     * @return the provided commit message, if any
     * @since 5.0
     */
    @Nonnull
    public Optional<String> getMessage() {
        return ofNullable(message);
    }

    /**
     * @return the path of the edited (or created) file
     */
    @Nonnull
    public String getPath() {
        return path;
    }
}
