package com.atlassian.bitbucket.event.commit;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Event that is raised when a comment is replied to in a commit discussion.
 */
@AsynchronousPreferred
@EventName("stash.commit.comment.replied")
public class CommitDiscussionCommentRepliedEvent extends CommitDiscussionCommentEvent {

    public CommitDiscussionCommentRepliedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                               @Nonnull Comment comment, @Nullable Comment parent) {
        super(source, discussion, comment, parent, CommentAction.REPLIED);
    }
}
