package com.atlassian.bitbucket.event.commit;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Event that is raised when a comment is edited in a commit discussion.
 */
@AsynchronousPreferred
@EventName("stash.commit.comment.edited")
public class CommitDiscussionCommentEditedEvent extends CommitDiscussionCommentEvent {

    private final String previousText;

    public CommitDiscussionCommentEditedEvent(@Nonnull Object source, @Nonnull CommitDiscussion discussion,
                                              @Nonnull Comment comment, @Nullable Comment parent,
                                              @Nonnull String previousText) {
        super(source, discussion, comment, parent, CommentAction.EDITED);

        this.previousText = checkNotNull(previousText, "previousText");
    }

    @Nonnull
    public String getPreviousText() {
        return previousText;
    }
}
