package com.atlassian.bitbucket.event.branch;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * An event that is raised when a branch is deleted using the UI or REST.
 * Branches deleted by pushing will not trigger this event.
 * <p>
 * Listeners that are interested in all repository changes should listen for
 * {@link RepositoryRefsChangedEvent}s instead.
 */
@AsynchronousPreferred
@EventName("stash.branch.deleted")
public class BranchDeletedEvent extends BranchChangedEvent {

    public BranchDeletedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Branch branch) {
        super(source, repository, branch, new SimpleRefChange.Builder()
                .from(branch)
                .toHash(EMPTY_HASH)
                .type(RefChangeType.DELETE)
                .build());
    }
}
