package com.atlassian.bitbucket.event.branch;

import com.atlassian.bitbucket.event.CancelableEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.CancelState;

import javax.annotation.Nonnull;

/**
 * An event that is raised just before a branch is created using the UI or REST.
 * Branches created by pushing will not trigger this event.
 * <p>
 * This event is {@link CancelableEvent cancelable}. A listener may prevent the branch
 * from being created by {@link #cancel(KeyedMessage) canceling} this event. Throwing an
 * exception <i>will not</i> prevent the branch from being created; the exception will be logged and ignored.
 *
 * @deprecated in 5.0 for removal in 6.0. Listeners for {@code BranchCreationRequestEvent} or one of its subclasses
 *             should implement a {@code PreRepositoryHook<BranchCreationHookRequest>} instead.
 */
@Deprecated
public class BranchCreationRequestedEvent extends BranchChangeRequestedEvent {

    public BranchCreationRequestedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Branch branch,
                                        @Nonnull CancelState cancelState) {
        super(source, repository, cancelState, branch);
    }
}
