package com.atlassian.bitbucket.event.branch;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * An event that is raised when a branch is created using the UI or REST. Branches
 * created by pushing will not trigger this event.
 * <p>
 * Listeners that are interested in all repository changes should listen for
 * {@link RepositoryRefsChangedEvent}s instead.
 */
@AsynchronousPreferred
@EventName("stash.branch.created")
public class BranchCreatedEvent extends BranchChangedEvent {

    public BranchCreatedEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Branch branch) {
        super(source, repository, branch, new SimpleRefChange.Builder()
                .fromHash(EMPTY_HASH)
                .to(branch)
                .type(RefChangeType.ADD)
                .build());
    }
}
