package com.atlassian.bitbucket.content;

import javax.annotation.Nonnull;
import java.io.IOException;

/**
 * Convenience implementation of {@link ContentTreeCallback} that provides no-op implementations for all methods.
 */
public class AbstractContentTreeCallback implements ContentTreeCallback {

    @Override
    public void onEnd(@Nonnull ContentTreeSummary summary) throws IOException {
    }

    @Override
    public void onStart(@Nonnull ContentTreeContext context) throws IOException {
    }

    /**
     * Discards the provided {@link ContentTreeNode} and returns {@code true} to continue streaming.
     *
     * @param node the current tree node
     * @return {@code true} if further nodes should be streamed; otherwise, {@code false} to stop streaming
     */
    @Override
    public boolean onTreeNode(@Nonnull ContentTreeNode node) throws IOException {
        return true;
    }
}
