package com.atlassian.bitbucket.commit.graph;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

/**
 * Contains a summary about the traversal which just ended.
 * <p>
 * This is currently just a placeholder and contains no interesting information.
 *
 * @see TraversalCallback#onEnd(TraversalSummary)
 */
public class TraversalSummary extends AbstractSummary {

    protected TraversalSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, TraversalSummary> {

        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public TraversalSummary build() {
            return new TraversalSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
