package com.atlassian.bitbucket.comment;

/**
 * An enumeration of anchor states for comment thread search
 *
 * @see CommentSearchRequest#getAnchorState()
 * @since 5.4
 */
public enum CommentThreadDiffAnchorState {

    /**
     * Only Active comments.
     */
    ACTIVE,
    /**
     * Only Orphaned comments.
     */
    ORPHANED,
    /**
     * Both Active and Outdated comments.
     */
    ALL;
}
