package com.atlassian.bitbucket.comment;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * @since 5.0
 */
public class AddCommentReplyRequest {

    private final long parentId;
    private final String text;

    private AddCommentReplyRequest(@Nonnull Builder builder) {
        parentId = builder.parentId;
        text = builder.text;
    }

    public long getParentId() {
        return parentId;
    }

    @Nonnull
    public String getText() {
        return text;
    }

    public static class Builder {

        private final long parentId;
        private final String text;

        public Builder(long parentId, @Nonnull String text) {
            this.parentId = parentId;
            this.text = requireNonNull(text, "text");
        }

        @Nonnull
        public AddCommentReplyRequest build() {
            return new AddCommentReplyRequest(this);
        }
    }
}
