package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Provides remember-me authentication
 *
 * @since 4.12
 */
public interface RememberMeService {

    /**
     * Attempts to authenticate a request using the remember-me cookie provided on the request. If authentication
     * succeeds, a new remember-me token is created for the user and a new cookie is set on the response. If
     * authentication fails for any reason, the cookie is cleared on the response.
     *
     * @param request the request
     * @param response the response
     * @return the authenticated user, or {@code null} if authentication failed.
     */
    @Nullable
    ApplicationUser authenticate(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response);

    /**
     * Clears the remember-me cookie and removes all remember-me tokens for the corresponding series
     *
     * @param request the request
     * @param response the response
     */
    void logout(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response);

    /**
     * Generates a new remember-me token for the user and sets the corresponding cookie on the response.
     * This will cancel an existing remember me cookie if such was provided. The user needs to be set in
     * the {@link AuthenticationContext} first.
     *
     * @param request the request
     * @param response the response
     */
    void createCookie(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response);
}
