package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * A specialisation of {@link AuthenticationException}, thrown to indicate the user cannot be authenticated because
 * they don't have permission to access the application.
 */
public class NoAccessAuthenticationException extends AuthenticationException {

    public NoAccessAuthenticationException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
