package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * A specialisation of {@link CaptchaAuthenticationException}, thrown when the CAPTCHA response provided by the user
 * does not match the image that was presented.
 */
public class IncorrectCaptchaAuthenticationException extends CaptchaAuthenticationException {

    public IncorrectCaptchaAuthenticationException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
