package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * A specialisation of {@link AuthenticationException}, thrown to indicate the user cannot be authenticated because
 * their password has expired and must be changed.
 */
public class ExpiredPasswordAuthenticationException extends AuthenticationException {

    public ExpiredPasswordAuthenticationException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
