package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;

/**
 * A specialisation of {@link CaptchaAuthenticationException}, thrown to indicate the user has entered their password
 * incorrectly too many times in succession and is required to solve a CAPTCHA before they will be allowed to login
 * again. This exception is also thrown if a CAPTCHA is required but was not provided.
 * <p>
 * To prevent brute force attempts to guess a user's password, the system can be configured to require a CAPTCHA after
 * a set number of failed authentication attempts. Administrators can set the number of failed attempts allowed before
 * a user's account will be locked.
 */
public class CaptchaRequiredAuthenticationException extends CaptchaAuthenticationException {

    public CaptchaRequiredAuthenticationException(@Nonnull KeyedMessage message) {
        super(message);
    }
}
