package com.atlassian.bitbucket;

import com.atlassian.bitbucket.i18n.KeyedMessage;

import javax.annotation.Nonnull;
import java.util.List;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

public class RequestCanceledException extends ServiceException {

    private final List<KeyedMessage> cancelMessages;

    public RequestCanceledException(@Nonnull KeyedMessage message, @Nonnull List<KeyedMessage> cancelMessages) {
        super(message);

        checkArgument(!checkNotNull(cancelMessages, "cancelMessages").isEmpty(),
                "At least one cancellation message must be provided");

        this.cancelMessages = cancelMessages;
    }

    @Nonnull
    public List<KeyedMessage> getCancelMessages() {
        return cancelMessages;
    }
}
