package com.atlassian.bitbucket;

import com.atlassian.bitbucket.i18n.KeyedMessage;

public class EntityOutOfDateException extends ServiceException {

    public static final int UNKNOWN_VERSION = -1;

    private static final long serialVersionUID = 1L;

    private final int currentVersion;
    private final int expectedVersion;

    public EntityOutOfDateException(KeyedMessage message, Throwable cause) {
        this(message, cause, UNKNOWN_VERSION, UNKNOWN_VERSION);
    }

    public EntityOutOfDateException(KeyedMessage message, int expectedVersion, int currentVersion) {
        super(message);

        this.expectedVersion = expectedVersion;
        this.currentVersion = currentVersion;
    }

    public EntityOutOfDateException(KeyedMessage message, Throwable cause, int expectedVersion, int currentVersion) {
        super(message, cause);

        this.expectedVersion = expectedVersion;
        this.currentVersion = currentVersion;
    }

    public int getCurrentVersion() {
        return currentVersion;
    }

    public int getExpectedVersion() {
        return expectedVersion;
    }
}
