/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.bulk;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class BulkContentContext {
    private final Optional<String> sinceCommitId;
    private final String untilCommitId;

    private BulkContentContext(Builder builder) {
        this.sinceCommitId = Optional.ofNullable(builder.sinceCommitId);
        this.untilCommitId = builder.untilCommitId;
    }

    @Nonnull
    public Optional<String> getSinceCommitId() {
        return this.sinceCommitId;
    }

    @Nonnull
    public String getUntilCommitId() {
        return this.untilCommitId;
    }

    public static class Builder {
        private final String untilCommitId;
        private String sinceCommitId;

        public Builder(@Nonnull String untilCommitId) {
            this.untilCommitId = Objects.requireNonNull(untilCommitId, "untilCommitId");
        }

        @Nonnull
        public Builder sinceCommitId(@Nonnull String value) {
            this.sinceCommitId = Objects.requireNonNull(value, "sinceCommitId");
            return this;
        }

        @Nonnull
        public BulkContentContext build() {
            return new BulkContentContext(this);
        }
    }
}

