/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights;

import com.atlassian.bitbucket.codeinsights.InsightAnnotation;
import com.atlassian.bitbucket.codeinsights.ParseResults;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.codehaus.plexus.logging.Logger;

public class BitbucketClient {
    private static final String TOKEN_VALUE = "no-check";
    private static final String TOKEN_HEADER = "X-Atlassian-Token";
    private final String reportKey;
    private final String reportTitle;
    private final String commitHash;
    private final Logger log;
    private final int maxAnnotationsToPost;
    private final String projectKey;
    private final String repository;
    private final int retries;
    private final String serverBaseUrl;
    private final String token;
    private final long waitTime;

    public BitbucketClient(Logger log, String reportKey, String reportTitle, String commitHash, int maxAnnotationsToPost, String projectKey, String repository, int retries, String serverBaseUrl, String token, long waitTime) {
        this.log = log;
        this.reportKey = reportKey;
        this.reportTitle = reportTitle;
        this.commitHash = commitHash;
        this.maxAnnotationsToPost = maxAnnotationsToPost;
        this.projectKey = projectKey;
        this.repository = repository;
        this.retries = retries;
        this.serverBaseUrl = serverBaseUrl;
        this.token = token;
        this.waitTime = waitTime;
    }

    public void writeToFile(File outputDirectory, ParseResults results) {
        this.log.debug("Write to file enabled will write to file report.json in: " + outputDirectory);
        HashMap<String, Object> report = new HashMap<String, Object>();
        report.put("title", this.reportTitle);
        report.put("result", this.getReportStatus(results));
        report.put("failed", results.getTestsFailed());
        report.put("error", results.getTestsInError());
        report.put("skipped", results.getSkippedTests());
        report.put("pass", results.getTestsPass());
        report.put("annotations", this.makeAnnotationList(results, Integer.MAX_VALUE));
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        File outputFile = new File(outputDirectory, "report.json");
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        try (FileWriter fout = new FileWriter(outputFile);){
            objectMapper.writeValue((Writer)fout, report);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void postResults(ParseResults results) {
        this.log.info("Post to server enabled, will post to " + this.serverBaseUrl);
        if (this.token.isEmpty()) {
            this.log.debug("No token set, not posting");
            return;
        }
        if (this.commitHash.isEmpty()) {
            this.log.debug("No commit hash set");
            return;
        }
        if (this.projectKey.isEmpty()) {
            this.log.debug("No project key set");
            return;
        }
        if (this.repository.isEmpty()) {
            this.log.debug("No repository set");
            return;
        }
        if (!this.haveTests(results)) {
            this.log.info("No tests found, not posting a report");
            return;
        }
        Client client = ClientBuilder.newClient();
        WebTarget reportTarget = client.target(this.serverBaseUrl).path("rest/insights/latest/projects").path(this.projectKey).path("repos").path(this.repository).path("commits").path(this.commitHash).path("reports").path(this.reportKey);
        Invocation.Builder builder = reportTarget.request().header("authorization", (Object)String.format("Bearer %s", this.token)).header(TOKEN_HEADER, (Object)TOKEN_VALUE);
        if (!this.makeRequest("Delete report", () -> ((Invocation.Builder)builder).delete())) {
            return;
        }
        this.log.info(String.format("Report with key '%s' deleted", this.reportKey));
        Map<String, Object> report = this.makeReport(results, this.reportTitle);
        if (!this.makeRequest("Create report", () -> builder.put(Entity.json((Object)report)))) {
            this.log.info("Creating report failed, aborting");
            return;
        }
        this.log.info(String.format("Report with key '%s' created", this.reportKey));
        List<Map<String, Object>> annotationList = this.makeAnnotationList(results, this.maxAnnotationsToPost);
        Map<String, Object> annotations = this.makeAnnotations(annotationList);
        if (this.makeRequest("Posting annotations", () -> reportTarget.path("annotations").request().header("authorization", (Object)String.format("Bearer %s", this.token)).header(TOKEN_HEADER, (Object)TOKEN_VALUE).post(Entity.json((Object)annotations)))) {
            this.log.info(String.format("%d  annotations created for report '%s'", annotationList.size(), this.reportKey));
        }
    }

    private boolean makeRequest(String action, Supplier<Response> builder) {
        int requestCount = 0;
        boolean successful = false;
        do {
            Response deleteResponse;
            if (this.handleResponse(action, deleteResponse = builder.get())) {
                successful = true;
                break;
            }
            if (++requestCount >= this.retries) continue;
            try {
                this.log.info(String.format("Request failed, waiting %d ms to try again. Attempt %d of %d", this.waitTime, requestCount, this.retries));
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } while (requestCount < this.retries);
        if (!successful) {
            this.log.info("Deleting report failed, aborting");
        }
        return successful;
    }

    private boolean haveTests(ParseResults results) {
        return results.getTestsFailed() + results.getSkippedTests() + results.getTestsInError() + results.getTestsPass() > 0;
    }

    private Map<String, Object> createDataEntry(String title, Object value) {
        HashMap<String, Object> entry = new HashMap<String, Object>();
        entry.put("title", title);
        entry.put("value", value);
        return entry;
    }

    private String getReportStatus(ParseResults results) {
        if (results.getTestsInError() > 0 || results.getTestsFailed() > 0) {
            return "FAIL";
        }
        return "PASS";
    }

    private boolean handleResponse(String action, Response response) {
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            if (response.getStatusInfo().toEnum() == Response.Status.REQUEST_ENTITY_TOO_LARGE) {
                if (response.hasEntity()) {
                    this.log.info("Too many annotations: " + (String)response.readEntity(String.class));
                } else {
                    this.log.info("Too many annotations for server");
                }
            } else {
                this.log.error(String.format("%s failed with response: %d", action, response.getStatus()));
                if (response.hasEntity()) {
                    this.log.debug((String)response.readEntity(String.class));
                }
                return false;
            }
        }
        return true;
    }

    private Map<String, Object> makeAnnotations(List<Map<String, Object>> annotations) {
        return Collections.singletonMap("annotations", annotations);
    }

    private List<Map<String, Object>> makeAnnotationList(ParseResults results, int maxSize) {
        ArrayList<Map<String, Object>> annotations = new ArrayList<Map<String, Object>>(results.getAnnotations().size());
        for (InsightAnnotation annotation : results.getAnnotations()) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("line", annotation.getLine());
            entry.put("message", annotation.getMessage());
            entry.put("path", annotation.getPath());
            entry.put("severity", "HIGH");
            annotations.add(entry);
            if (annotations.size() != maxSize) continue;
            this.log.info(String.format("Annotation limit reached. Will post the first %d out of a total of %d annotations produced", maxSize, results.getAnnotations().size()));
            break;
        }
        return annotations;
    }

    private Map<String, Object> makeReport(ParseResults results, String reportTitle) {
        HashMap<String, Object> report = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        report.put("title", reportTitle);
        report.put("result", this.getReportStatus(results));
        report.put("data", data);
        data.add(this.createDataEntry("Failed", results.getTestsFailed()));
        data.add(this.createDataEntry("Error", results.getTestsInError()));
        data.add(this.createDataEntry("Skipped", results.getSkippedTests()));
        data.add(this.createDataEntry("Pass", results.getTestsPass()));
        return report;
    }
}

