/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.php.task;

import com.atlassian.bamboo.plugins.php.task.PhpUnitConfig;
import com.atlassian.bamboo.process.CommandlineStringUtils;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPhpUnitConfig
implements PhpUnitConfig {
    private static final Logger log = Logger.getLogger(AbstractPhpUnitConfig.class);
    public static final String CFG_ARGUMENTS = "arguments";
    public static final String CFG_LOG_JUNIT_ENABLED = "logXmlEnabled";
    public static final String CFG_LOG_JUNIT_ENABLED_BOOLEAN = "isLogXmlEnabled";
    public static final String CFG_LOG_JUNIT_FILENAME = "logXmlFile";
    public static final String CFG_COVERAGE_HTML_ENABLED = "coverageHtmlEnabled";
    public static final String CFG_COVERAGE_HTML_ENABLED_BOOLEAN = "isCoverageHtmlEnabled";
    public static final String CFG_COVERAGE_HTML_DIRECTORY_NAME = "coverageHtmlDirectory";
    private final File rootDirectory;
    private final List<String> arguments;
    private final String builderPath;
    private final boolean logJunitEnabled;
    private final String logJunitFilename;
    private final boolean coverageHtmlEnabled;
    private final String coverageHtmlDirectoryName;
    private final File workingDirectory;
    private final Map<String, String> extraEnvironment = Maps.newHashMap();
    private List<String> commandline;

    public AbstractPhpUnitConfig(@NotNull TaskContext taskContext, @NotNull CapabilityContext capabilityContext, @NotNull String capabilityPrefix, @NotNull EnvironmentVariableAccessor environmentVariableAccessor) {
        this.rootDirectory = taskContext.getRootDirectory();
        String builderLabel = (String)Preconditions.checkNotNull((Object)taskContext.getConfigurationMap().get((Object)"label"), (Object)"Builder label is not defined");
        this.builderPath = (String)Preconditions.checkNotNull((Object)capabilityContext.getCapabilityValue(capabilityPrefix + "." + builderLabel), (Object)"Builder path is not defined");
        this.arguments = CommandlineStringUtils.tokeniseCommandline((String)StringUtils.replaceChars((String)((String)taskContext.getConfigurationMap().get((Object)CFG_ARGUMENTS)), (String)"\r\n", (String)"  "));
        this.logJunitEnabled = taskContext.getConfigurationMap().getAsBoolean(CFG_LOG_JUNIT_ENABLED);
        this.logJunitFilename = (String)taskContext.getConfigurationMap().get((Object)CFG_LOG_JUNIT_FILENAME);
        this.coverageHtmlEnabled = taskContext.getConfigurationMap().getAsBoolean(CFG_COVERAGE_HTML_ENABLED);
        this.coverageHtmlDirectoryName = (String)taskContext.getConfigurationMap().get((Object)CFG_COVERAGE_HTML_DIRECTORY_NAME);
        this.workingDirectory = taskContext.getWorkingDirectory();
        String environmentVariables = (String)taskContext.getConfigurationMap().get((Object)"environmentVariables");
        this.extraEnvironment.putAll(environmentVariableAccessor.splitEnvironmentAssignments(environmentVariables, false));
    }

    @NotNull
    protected abstract List<String> buildCommandline();

    @Override
    @NotNull
    public List<String> getCommandline() {
        if (this.commandline == null) {
            this.commandline = this.buildCommandline();
        }
        return this.commandline;
    }

    @Override
    @NotNull
    public Map<String, String> getExtraEnvironment() {
        return this.extraEnvironment;
    }

    @Override
    @NotNull
    public List<String> getArguments() {
        return this.arguments;
    }

    public String getBuilderPath() {
        return this.builderPath;
    }

    @Nullable
    public String getCoverageHtmlDirectoryName() {
        return this.coverageHtmlDirectoryName;
    }

    public boolean isCoverageHtmlEnabled() {
        return this.coverageHtmlEnabled;
    }

    @Override
    public boolean isLogJunitEnabled() {
        return this.logJunitEnabled;
    }

    @Override
    @Nullable
    public String getLogJunitFilename() {
        return this.logJunitFilename;
    }

    @Override
    @NotNull
    public File getRootDirectory() {
        return this.rootDirectory;
    }

    @Override
    @NotNull
    public File getWorkingDirectory() {
        return this.workingDirectory;
    }
}

