/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.builder.php;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.AbstractBuilder;
import com.atlassian.bamboo.command.Command;
import com.atlassian.bamboo.command.CommandException;
import com.atlassian.bamboo.command.CommandExecuteStreamHandler;
import com.atlassian.bamboo.configuration.LabelPathMap;
import com.atlassian.bamboo.plugins.builder.php.CloverPhpUnitCommandDecorator;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.utils.map.FilteredMap;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhpUnitBuilder
extends AbstractBuilder {
    private static final Logger log = Logger.getLogger(PhpUnitBuilder.class);
    public static final String NAME = "PHPUnit";
    public static final String PATHHELP = "Please enter path to PHPUnit e.g. /usr/bin/phpunit";
    private static final String BUILDER_TYPE = "com.atlassian.bamboo.plugins.builder.php:phpunit";
    private static final String BUILDER_PATH_LABEL = "PHPUnit 3/4";
    private static final String PARAM_ARGUMENTS = "arguments";
    private static final String PARAM_LOG_XML_ENABLED = "logXmlEnabled";
    private static final String PARAM_LOG_XML_FILE = "logXmlFile";
    private static final String PARAM_COVERAGE_HTML_ENABLED = "coverageHtmlEnabled";
    private static final String PARAM_COVERAGE_HTML_DIRECTORY = "coverageHtmlDirectory";
    private static final String DEFAULT_ARGUMENTS = ".";
    private static final boolean DEFAULT_LOG_XML_ENABLED = false;
    private static final String DEFAULT_LOG_XML_FILE = StringUtils.join((Object[])new String[]{"test-reports", "phpunit.xml"}, (String)File.separator);
    private static final boolean DEFAULT_COVERAGE_HTML_ENABLED = false;
    private static final String DEFAULT_COVERAGE_HTML_DIRECTORY = StringUtils.join((Object[])new String[]{"test-reports", "coverage", "html"}, (String)File.separator);
    protected static final String BUILD_SUCCESSFUL_MARKER = "OK";
    protected String myTestDirectoryOption;
    protected String arguments = ".";
    protected boolean logXmlEnabled = true;
    protected String logXmlFile = DEFAULT_LOG_XML_FILE;
    protected boolean coverageHtmlEnabled = true;
    protected String coverageHtmlDirectory = DEFAULT_COVERAGE_HTML_DIRECTORY;
    protected String options;

    @NotNull
    public String getCommandExecutable(ReadOnlyCapabilitySet capabilitySet) {
        return StringUtils.defaultString((String)this.getPath(capabilitySet));
    }

    @NotNull
    public String[] getCommandArguments(ReadOnlyCapabilitySet capabilitySet) {
        ArrayList<String> commands = new ArrayList<String>();
        if (this.isLogXmlEnabled()) {
            commands.addAll(Arrays.asList("--log-xml", this.stripWorkingSubDirectory(this.getLogXmlFile())));
        }
        if (this.isCoverageHtmlEnabled()) {
            commands.addAll(Arrays.asList("--coverage-html", this.stripWorkingSubDirectory(this.getCoverageHtmlDirectory())));
        }
        String argumentsWithoutNewLines = this.getArgumentsWithoutNewLines();
        commands.add(argumentsWithoutNewLines);
        return commands.toArray(new String[commands.size()]);
    }

    public ErrorCollection validate(FilteredMap filteredParams) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (StringUtils.isEmpty((String)((String)filteredParams.get((Object)PARAM_ARGUMENTS)))) {
            errorCollection.addError(this.getKeyPrefix(), PARAM_ARGUMENTS, "Please specifiy the PHP Unit target");
        }
        boolean tmpIsLogXmlEnabled = Boolean.valueOf((String)filteredParams.get((Object)PARAM_LOG_XML_ENABLED));
        String tmpLogXmlFile = (String)filteredParams.get((Object)PARAM_LOG_XML_FILE);
        if (tmpIsLogXmlEnabled && StringUtils.isEmpty((String)tmpLogXmlFile)) {
            errorCollection.addError(this.getKeyPrefix(), PARAM_LOG_XML_FILE, "Please specifiy the XML log file");
        }
        return errorCollection;
    }

    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SubnodeConfiguration config = buildConfiguration.configurationAt(this.getKeyPrefix());
        if (StringUtils.isBlank((String)config.getString(PARAM_ARGUMENTS))) {
            errorCollection.addError(this.getKeyPrefix(), PARAM_ARGUMENTS, "Please specifiy the PHP Unit target");
        }
        boolean tmpIsLogXmlEnabled = config.getBoolean(PARAM_LOG_XML_ENABLED, false);
        String tmpLogXmlFile = config.getString(PARAM_LOG_XML_FILE);
        if (tmpIsLogXmlEnabled && StringUtils.isEmpty((String)tmpLogXmlFile)) {
            errorCollection.addError(this.getKeyPrefix(), PARAM_LOG_XML_FILE, "Please specifiy the XML log file");
        }
        return errorCollection;
    }

    public void addDefaultValues(@NotNull BuildConfiguration configuration) {
        configuration.setProperty(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_ARGUMENTS, (Object)DEFAULT_ARGUMENTS);
        configuration.setProperty(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_LOG_XML_ENABLED, (Object)false);
        configuration.setProperty(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_LOG_XML_FILE, (Object)DEFAULT_LOG_XML_FILE);
        configuration.setProperty(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_COVERAGE_HTML_ENABLED, (Object)false);
        configuration.setProperty(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_COVERAGE_HTML_DIRECTORY, (Object)DEFAULT_COVERAGE_HTML_DIRECTORY);
    }

    public Map<String, LabelPathMap> addDefaultLabelPathMaps(Map<String, LabelPathMap> labelPathMaps) {
        String[] paths;
        for (String path : paths = StringUtils.split((String)SystemProperty.PATH.getValue(), (String)File.pathSeparator)) {
            File phpUnit = new File(path, "phpunit");
            if (!phpUnit.exists()) continue;
            if (labelPathMaps == null) {
                labelPathMaps = Maps.newHashMap();
            }
            labelPathMaps.put(BUILDER_PATH_LABEL, new LabelPathMap(BUILDER_PATH_LABEL, phpUnit.getAbsolutePath(), BUILDER_TYPE));
            break;
        }
        return labelPathMaps;
    }

    public boolean hasPassed(int returnCode, int buildNumber, String planKey) {
        BuildLogger buildLogger = this.buildLoggerManager.getBuildLogger(planKey);
        if (returnCode == 0) {
            if (this.outputEndsWith(FIND_SUCCESS_MESSAGE_IN_LAST, BUILD_SUCCESSFUL_MARKER, planKey, buildNumber)) {
                log.info((Object)buildLogger.addBuildLogEntry("Build successful since return code was 0 and the text 'OK' was found."));
                return true;
            }
            log.info((Object)buildLogger.addBuildLogEntry("Build failed since text 'OK' was not found in the last " + FIND_SUCCESS_MESSAGE_IN_LAST + " lines of the output."));
            return false;
        }
        log.info((Object)buildLogger.addBuildLogEntry("Build failed since return code was not 0"));
        return false;
    }

    public void setParams(@NotNull FilteredMap filteredBuilderParams) {
        super.setParams(filteredBuilderParams);
        if (filteredBuilderParams.containsKey((Object)PARAM_ARGUMENTS)) {
            this.setArguments((String)filteredBuilderParams.get((Object)PARAM_ARGUMENTS));
        }
        if (filteredBuilderParams.containsKey((Object)PARAM_LOG_XML_ENABLED)) {
            this.setLogXmlEnabled(Boolean.valueOf((String)filteredBuilderParams.get((Object)PARAM_LOG_XML_ENABLED)));
        } else {
            this.setLogXmlEnabled(false);
        }
        if (filteredBuilderParams.containsKey((Object)PARAM_LOG_XML_FILE)) {
            this.setLogXmlFile((String)filteredBuilderParams.get((Object)PARAM_LOG_XML_FILE));
        }
        if (filteredBuilderParams.containsKey((Object)PARAM_COVERAGE_HTML_ENABLED)) {
            this.setCoverageHtmlEnabled(Boolean.valueOf((String)filteredBuilderParams.get((Object)PARAM_COVERAGE_HTML_ENABLED)));
        } else {
            this.setCoverageHtmlEnabled(false);
        }
        if (filteredBuilderParams.containsKey((Object)PARAM_COVERAGE_HTML_DIRECTORY)) {
            this.setCoverageHtmlDirectory((String)filteredBuilderParams.get((Object)PARAM_COVERAGE_HTML_DIRECTORY));
        }
    }

    @NotNull
    public Map<String, String> getFullParams() {
        Map fieldParams = super.getFullParams();
        fieldParams.put(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_ARGUMENTS, this.getArguments());
        fieldParams.put(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_LOG_XML_ENABLED, Boolean.toString(this.isLogXmlEnabled()));
        fieldParams.put(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_LOG_XML_FILE, this.getLogXmlFile());
        fieldParams.put(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_COVERAGE_HTML_ENABLED, Boolean.toString(this.isCoverageHtmlEnabled()));
        fieldParams.put(this.getKeyPrefix() + DEFAULT_ARGUMENTS + PARAM_COVERAGE_HTML_DIRECTORY, this.getCoverageHtmlDirectory());
        return fieldParams;
    }

    public int executeCommand(@NotNull BuildContext buildContext, @NotNull CommandExecuteStreamHandler commandExecuteStreamHandler, String extraEnvironmentVariables, String javaHome, ReadOnlyCapabilitySet capabilitySet) throws CommandException {
        if (this.isLogXmlEnabled()) {
            File parentDirectory = new File(this.getBuildDir(), this.getLogXmlFile()).getParentFile();
            this.makeDirectory(parentDirectory);
        }
        if (this.isCoverageHtmlEnabled()) {
            File directory = new File(this.getBuildDir(), this.getCoverageHtmlDirectory());
            this.makeDirectory(directory);
        }
        CloverPhpUnitCommandDecorator commandDecorator = new CloverPhpUnitCommandDecorator();
        commandDecorator.init(buildContext);
        if (commandDecorator.canDecorate((Command)this)) {
            File cloverCoverageDirectory = new File(this.getBuildDir(), commandDecorator.getCloverCoverageFilename()).getParentFile();
            this.makeDirectory(cloverCoverageDirectory);
        }
        return super.executeCommand(buildContext, commandExecuteStreamHandler, extraEnvironmentVariables, javaHome, capabilitySet);
    }

    public boolean hasTests() {
        return this.isLogXmlEnabled();
    }

    public String getTestResultsDirectory() {
        return new File(this.getLogXmlFile()).getParent() + File.separator + "*.xml";
    }

    String getArgumentsWithoutNewLines() {
        return StringUtils.replaceChars((String)this.getArguments(), (String)"\r\n", (String)"  ");
    }

    public boolean isPathValid(String path) {
        if (path != null) {
            File file = new File(path);
            return file.exists() && file.isFile();
        }
        return false;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    protected String[] getCustomEnvironmentVars(ReadOnlyCapabilitySet capabilitySet) {
        return null;
    }

    @NotNull
    public String getPathHelp() {
        return PATHHELP;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getArguments() {
        return this.arguments;
    }

    public boolean isLogXmlEnabled() {
        return this.logXmlEnabled;
    }

    public void setLogXmlEnabled(boolean logXmlEnabled) {
        this.logXmlEnabled = logXmlEnabled;
    }

    public String getLogXmlFile() {
        return this.logXmlFile;
    }

    public void setLogXmlFile(String logXmlFile) {
        this.logXmlFile = logXmlFile;
    }

    public boolean isCoverageHtmlEnabled() {
        return this.coverageHtmlEnabled;
    }

    public void setCoverageHtmlEnabled(boolean coverageHtmlEnabled) {
        this.coverageHtmlEnabled = coverageHtmlEnabled;
    }

    public String getCoverageHtmlDirectory() {
        return this.coverageHtmlDirectory;
    }

    public void setCoverageHtmlDirectory(String coverageHtmlDirectory) {
        this.coverageHtmlDirectory = coverageHtmlDirectory;
    }

    private String stripWorkingSubDirectory(@NotNull String path) {
        if (StringUtils.isNotEmpty((String)this.getWorkingSubDirectory())) {
            return path.replaceFirst("^" + this.getWorkingSubDirectory() + "/", "");
        }
        return path;
    }

    private void makeDirectory(@NotNull File directory) {
        if (!directory.exists() && directory.mkdirs()) {
            log.warn((Object)("Failed to create directory [" + directory.getPath() + "]"));
        }
    }
}

