/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.ssh;

import com.atlassian.bamboo.plugins.ssh.SshMessageHandler;
import com.atlassian.bamboo.plugins.ssh.SshProxy;
import com.atlassian.bamboo.ssh.ProxyConnectionData;
import com.atlassian.bamboo.ssh.ProxyConnectionDataProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.ChannelUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;

public class SshProxyCommand
implements Command,
SshMessageHandler {
    private static final Logger log = Logger.getLogger(SshProxy.class);
    private final String command;
    private final ProxyConnectionDataProvider proxyConnectionDataProvider;
    private OutputStream outputStream;
    private InputStream inputStream;
    private OutputStream errorStream;
    private ExitCallback exitCallback;
    private SshClient client;
    private ClientSession session;
    private ProxyConnectionData connectionData;
    private ChannelExec channel;

    public SshProxyCommand(SshClient client, ProxyConnectionDataProvider proxyConnectionDataProvider, String command) {
        this.client = client;
        this.command = command;
        this.proxyConnectionDataProvider = proxyConnectionDataProvider;
    }

    public void setInputStream(InputStream in) {
        this.inputStream = in;
    }

    public void setOutputStream(OutputStream out) {
        this.outputStream = out;
    }

    public void setErrorStream(OutputStream err) {
        this.errorStream = err;
    }

    public void setExitCallback(ExitCallback callback) {
        this.exitCallback = callback;
    }

    public void start(Environment env) throws IOException {
        log.debug((Object)("Start called: " + env.getEnv().toString()));
        String proxyUserName = (String)env.getEnv().get("USER");
        if (proxyUserName == null) {
            String msg = "Expected USER to be set: " + env.getEnv().toString();
            log.error((Object)msg);
            this.writeToErrorStream(msg);
            this.exitCallback.onExit(255);
            return;
        }
        this.connectionData = this.proxyConnectionDataProvider.getConnectionData(proxyUserName);
        if (this.connectionData == null) {
            String msg = "Cannot map user to connection data: " + proxyUserName;
            log.error((Object)msg);
            this.writeToErrorStream(msg);
            this.exitCallback.onExit(255);
            return;
        }
        new Thread("Connection monitoring thread - " + proxyUserName){

            @Override
            public void run() {
                try {
                    SshProxyCommand.this.startRemoteConnection();
                }
                catch (Exception e) {
                    SshProxyCommand.this.finishWithError("Error while opening SSH session", e);
                }
            }
        }.start();
    }

    public void destroy() {
        log.debug((Object)"Destroy called");
        new Thread("Connection killer"){

            @Override
            public void run() {
                SshProxyCommand.this.closeSession();
            }
        }.start();
    }

    private synchronized void startRemoteConnection() {
        ConnectFuture connectFuture;
        log.debug((Object)"Connecting client");
        try {
            connectFuture = this.client.connect(this.connectionData.getRemoteAddress());
        }
        catch (Exception e) {
            this.finishWithError("Remote connection failed", e);
            return;
        }
        this.session = ((ConnectFuture)connectFuture.awaitUninterruptibly()).getSession();
        if (!connectFuture.isConnected()) {
            this.finishWithError("Can't connect session, connectFuture is not connected...", connectFuture.getException());
            return;
        }
        this.connectSession();
    }

    private void connectSession() {
        AuthFuture authFuture;
        try {
            log.debug((Object)"Authenticating");
            String remotePassword = this.connectionData.getRemotePassword();
            if (StringUtils.isNotBlank((String)remotePassword)) {
                log.debug((Object)"Authenticating with password");
                authFuture = this.session.authPassword(this.connectionData.getRemoteUserName(), remotePassword);
            } else {
                log.debug((Object)"Authenticating with keyPair");
                authFuture = this.session.authPublicKey(this.connectionData.getRemoteUserName(), this.connectionData.getKeyPair());
            }
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            this.finishWithError("Authenticating remote session failed", e);
            return;
        }
        authFuture.awaitUninterruptibly();
        if (authFuture.isSuccess()) {
            this.createExecChannel();
        } else {
            this.finishWithError("Authenticating remote session failed", authFuture.getException());
        }
    }

    private void createExecChannel() {
        OpenFuture openFuture;
        log.debug((Object)"Creating exec channel");
        try {
            this.channel = this.session.createExecChannel(this.mapPaths(this.command));
        }
        catch (Exception e) {
            this.finishWithError("Error creating exec channel", e);
            return;
        }
        this.channel.setIn(this.inputStream);
        this.channel.setErr(this.errorStream);
        this.channel.setOut(this.outputStream);
        try {
            openFuture = this.channel.open();
        }
        catch (Exception e) {
            this.finishWithError("Error opening exec channel", e);
            return;
        }
        openFuture.awaitUninterruptibly();
        if (openFuture.isOpened()) {
            int ret = this.channel.waitFor(3, 0L);
            log.debug((Object)("Session wait: " + ret));
            this.finishCleanly();
        } else {
            this.finishWithError("Error opening exec channel", openFuture.getException());
        }
    }

    private String mapPaths(String command) {
        if (this.connectionData.getMapPathFrom() != null) {
            String replacement;
            String toReplace = "'" + this.connectionData.getMapPathFrom() + "'";
            String commandWithPathsReplaced = command.replaceAll(toReplace, replacement = "'" + this.connectionData.getMapPathTo() + "'");
            if (commandWithPathsReplaced.equals(command)) {
                if (command.contains(replacement)) {
                    log.info((Object)("Already replaced " + command));
                } else {
                    log.warn((Object)("Did not replace anything in " + command));
                }
            } else {
                log.debug((Object)("Replaced paths from: " + command + " to " + commandWithPathsReplaced));
            }
            return commandWithPathsReplaced;
        }
        return command;
    }

    synchronized void closeSession() {
        log.debug((Object)"Closing session");
        if (this.session != null) {
            this.session.close(true);
            this.session = null;
        }
    }

    private void finishCleanly() {
        log.debug((Object)"Connection finished");
        this.closeSession();
        this.exitCallback.onExit(0);
    }

    private void finishWithError(String msg, Throwable t) {
        this.connectionData.reportProxyError(msg, t);
        StringBuilder sb = new StringBuilder("While connecting to [").append(this.connectionData.getRemoteUserName()).append("@").append(this.connectionData.getRemoteAddress()).append("]: ").append(msg);
        String logMessage = sb.toString();
        log.warn((Object)logMessage, t);
        String errorMessage = t == null ? logMessage : sb.append(": ").append(t.getMessage()).toString();
        this.writeToErrorStream(errorMessage);
        this.exitCallback.onExit(255);
        this.closeSession();
    }

    private void writeToErrorStream(String errorMessage) {
        try {
            this.errorStream.write(errorMessage.getBytes());
            this.errorStream.write(10);
            this.errorStream.flush();
        }
        catch (IOException e) {
            log.warn((Object)"Cannot write error message to the client", (Throwable)e);
        }
    }

    @Override
    public void onEof() throws IOException {
        ChannelUtils.sendEof((AbstractChannel)this.channel);
    }

    @Override
    public void onClose() {
        ChannelUtils.close((Channel)this.channel);
    }
}

