/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git.v2.configurator;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.plugins.git.GitAuthenticationType;
import com.atlassian.bamboo.plugins.git.GitPasswordCredentialsSource;
import com.atlassian.bamboo.plugins.git.GitSshCredentialsSource;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsType;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitServerConfigurator
implements VcsLocationConfigurator {
    private static final Logger log = Logger.getLogger(GitServerConfigurator.class);
    private final I18nResolver i18nResolver;
    private final FeatureManager featureManager;
    private final CustomVariableContext customVariableContext;
    private final CredentialsAccessor credentialsAccessor;

    @Inject
    public GitServerConfigurator(I18nResolver i18nResolver, FeatureManager featureManager, CustomVariableContext customVariableContext, CredentialsAccessor credentialsAccessor) {
        this.i18nResolver = i18nResolver;
        this.featureManager = featureManager;
        this.customVariableContext = customVariableContext;
        this.credentialsAccessor = credentialsAccessor;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        context.put("repository.git.commandTimeout", 180);
        context.put("repository.git.useRemoteAgentCache", true);
        context.put("repository.git.authenticationType", GitAuthenticationType.NONE.name());
        context.put("repository.git.sshCredentialsSource", this.getDefaultSshCredentialsSource().name());
        context.put("repository.git.passwordCredentialsSource", this.getDefaultPasswordCredentialsSource().name());
        this.populateSelectListItems(context);
    }

    private String getAuthTypeName(String authType) {
        return this.i18nResolver.getText("repository.git.authenticationType." + StringUtils.lowerCase((String)authType));
    }

    private String getSshCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.git.sshCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    private String getPasswordCredentialsSourceName(String source) {
        return this.i18nResolver.getText("repository.git.passwordCredentialsSource." + StringUtils.lowerCase((String)source));
    }

    private GitSshCredentialsSource getDefaultSshCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials") ? GitSshCredentialsSource.SHARED_CREDENTIALS : GitSshCredentialsSource.CUSTOM;
    }

    private GitPasswordCredentialsSource getDefaultPasswordCredentialsSource() {
        return this.credentialsAccessor.hasAnyCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials") ? GitPasswordCredentialsSource.SHARED_CREDENTIALS : GitPasswordCredentialsSource.CUSTOM;
    }

    @NotNull
    private List<NameValuePair> getSshSharedCredentials() {
        return this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:sshCredentials");
    }

    @NotNull
    private List<NameValuePair> getPasswordSharedCredentials() {
        return this.getSharedCredentials("com.atlassian.bamboo.plugin.sharedCredentials:usernamePasswordCredentials");
    }

    @NotNull
    private List<NameValuePair> getSharedCredentials(String pluginKey) {
        return BambooIterables.stream((Iterable)this.credentialsAccessor.getAllCredentials(pluginKey)).map(credentials -> new NameValuePair(Long.toString(credentials.getId()), credentials.getName())).collect(Collectors.toList());
    }

    private List<NameValuePair> getGitAuthenticationTypes() {
        return Arrays.stream(GitAuthenticationType.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getAuthTypeName((String)name))).collect(Collectors.toList());
    }

    public List<NameValuePair> getSshCredentialsSources() {
        return Arrays.stream(GitSshCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getSshCredentialsSourceName((String)name))).collect(Collectors.toList());
    }

    private List<NameValuePair> getPasswordCredentialsSources() {
        return Arrays.stream(GitPasswordCredentialsSource.values()).map(Enum::name).map(name -> new NameValuePair(name, this.getPasswordCredentialsSourceName((String)name))).collect(Collectors.toList());
    }

    private void populateSelectListItems(@NotNull Map<String, Object> context) {
        context.put("gitAuthenticationTypes", this.getGitAuthenticationTypes());
        context.put("sshCredentialsSources", this.getSshCredentialsSources());
        context.put("passwordCredentialsSources", this.getPasswordCredentialsSources());
        context.put("sshSharedCredentials", this.getSshSharedCredentials());
        context.put("passwordSharedCredentials", this.getPasswordSharedCredentials());
    }

    private void populateContextCommon(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        block14: {
            Map cfg = vcsLocationDefinition.getConfiguration();
            context.put("repository.git.repositoryUrl", cfg.get("repository.git.repositoryUrl"));
            context.put("repository.git.useShallowClones", Boolean.parseBoolean((String)cfg.get("repository.git.useShallowClones")));
            context.put("repository.git.useRemoteAgentCache", cfg.get("repository.git.useRemoteAgentCache"));
            context.put("repository.git.useSubmodules", cfg.get("repository.git.useSubmodules"));
            context.put("repository.git.commandTimeout", cfg.get("repository.git.commandTimeout"));
            context.put("repository.git.verbose.logs", cfg.get("repository.git.verbose.logs"));
            context.put("repository.git.fetch.whole.repository", Boolean.parseBoolean((String)cfg.get("repository.git.fetch.whole.repository")));
            context.put("repository.git.lfs", Boolean.parseBoolean((String)cfg.get("repository.git.lfs")));
            String authenticationTypeString = (String)cfg.get("repository.git.authenticationType");
            context.put("repository.git.authenticationType", authenticationTypeString);
            GitAuthenticationType authenticationType = GitAuthenticationType.valueOf(authenticationTypeString);
            block0 : switch (authenticationType) {
                case NONE: {
                    context.put("repository.git.sshCredentialsSource", this.getDefaultSshCredentialsSource().name());
                    context.put("repository.git.passwordCredentialsSource", this.getDefaultPasswordCredentialsSource().name());
                    break;
                }
                case PASSWORD: {
                    String passwordCredentialsSourceString = (String)cfg.get("repository.git.passwordCredentialsSource");
                    context.put("repository.git.passwordCredentialsSource", passwordCredentialsSourceString);
                    context.put("repository.git.sshCredentialsSource", this.getDefaultSshCredentialsSource().name());
                    switch (GitPasswordCredentialsSource.valueOf(passwordCredentialsSourceString)) {
                        case SHARED_CREDENTIALS: {
                            String passwordSharedCredentialsId = (String)cfg.get("repository.git.passwordSharedCredentials");
                            context.put("repository.git.passwordSharedCredentials", passwordSharedCredentialsId);
                            if (this.credentialExists(Long.parseLong(passwordSharedCredentialsId))) break;
                            context.put("repository.git.sharedCredentials.deleted", true);
                            break;
                        }
                        case CUSTOM: {
                            context.put("repository.git.passwordCredentialsSource", GitPasswordCredentialsSource.CUSTOM.name());
                            context.put("repository.git.username", cfg.get("repository.git.username"));
                            this.putDummyIfValueIsNotBlank(context, cfg, "repository.git.password");
                        }
                    }
                    break;
                }
                case SSH_KEYPAIR: {
                    String sshCredentialsSourceString = (String)cfg.get("repository.git.sshCredentialsSource");
                    context.put("repository.git.sshCredentialsSource", sshCredentialsSourceString);
                    context.put("repository.git.passwordCredentialsSource", this.getDefaultPasswordCredentialsSource().name());
                    switch (GitSshCredentialsSource.valueOf(sshCredentialsSourceString)) {
                        case SHARED_CREDENTIALS: {
                            String sshSharedCredentialsId = (String)cfg.get("repository.git.sharedCredentials");
                            context.put("repository.git.sharedCredentials", sshSharedCredentialsId);
                            if (!this.credentialExists(Long.parseLong(sshSharedCredentialsId))) {
                                context.put("repository.git.sharedCredentials.deleted", true);
                                break block0;
                            }
                            break block14;
                        }
                        case CUSTOM: {
                            this.putDummyIfValueIsNotBlank(context, cfg, "repository.git.ssh.key");
                            this.putDummyIfValueIsNotBlank(context, cfg, "repository.git.ssh.passphrase");
                        }
                    }
                }
            }
        }
    }

    private void putDummyIfValueIsNotBlank(@NotNull Map<String, Object> context, @NotNull Map<String, String> cfg, String key) {
        if (StringUtils.isNotBlank((CharSequence)cfg.get(key))) {
            context.put(key, "dummy");
        }
    }

    @NotNull
    public Iterable<Long> getSharedCredentialsIds(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        ArrayList<Long> result = new ArrayList<Long>();
        String sharedCredentialsId = (String)vcsLocationDefinition.getConfiguration().get("repository.git.sharedCredentials");
        if (sharedCredentialsId == null) {
            sharedCredentialsId = (String)vcsLocationDefinition.getConfiguration().get("repository.git.passwordSharedCredentials");
        }
        if (sharedCredentialsId != null) {
            result.add(Long.parseLong(sharedCredentialsId));
        }
        return result;
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
        this.populateSelectListItems(context);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
        this.populateSelectListItems(context);
    }

    private GitAuthenticationType getGitAuthenticationType(ActionParametersMap actionParametersMap) {
        String authTypeString = actionParametersMap.getString("repository.git.authenticationType");
        if (!StringUtils.isBlank((CharSequence)authTypeString)) {
            return GitAuthenticationType.valueOf(authTypeString);
        }
        return GitAuthenticationType.NONE;
    }

    private String substituteString(@Nullable String stringWithValuesToSubstitute) {
        return this.customVariableContext.substituteString(stringWithValuesToSubstitute);
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousDefinition, @NotNull ErrorCollection errorCollection) {
        Map<String, String> cfgMap;
        block18: {
            cfgMap = this.generateConfigMap(actionParametersMap, previousDefinition);
            String repositoryUrl = StringUtils.trim((String)cfgMap.get("repository.git.repositoryUrl"));
            GitAuthenticationType authenticationType = this.getGitAuthenticationType(actionParametersMap);
            if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)"repository.git.repositoryUrl", (String)this.substituteString(cfgMap.get("repository.git.repositoryUrl")))) {
                return;
            }
            if (BambooFieldValidate.findFieldShellInjectionViolation((ErrorCollection)errorCollection, (I18nResolver)this.i18nResolver, (String)"repository.git.username", (String)this.substituteString(cfgMap.get("repository.git.username")))) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)repositoryUrl)) {
                errorCollection.addError("repository.git.repositoryUrl", this.i18nResolver.getText("repository.git.messages.missingRepositoryUrl"));
            } else {
                GitPasswordCredentialsSource passwordCredentialsSource = authenticationType == GitAuthenticationType.PASSWORD ? GitPasswordCredentialsSource.valueOf(cfgMap.get("repository.git.passwordCredentialsSource")) : null;
                boolean hasUsername = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS || StringUtils.isNotBlank((CharSequence)cfgMap.get("repository.git.username"));
                boolean hasPassword = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS || StringUtils.isNotBlank((CharSequence)cfgMap.get("repository.git.password"));
                try {
                    URIish uri = new URIish(repositoryUrl);
                    if (authenticationType == GitAuthenticationType.SSH_KEYPAIR) {
                        GitSshCredentialsSource sshCredentialsSource;
                        if ("http".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                            errorCollection.addError("repository.git.authenticationType", this.i18nResolver.getText("repository.git.messages.unsupportedHttpAuthenticationType"));
                        }
                        if ((sshCredentialsSource = GitSshCredentialsSource.valueOf(cfgMap.get("repository.git.sshCredentialsSource"))) == GitSshCredentialsSource.SHARED_CREDENTIALS && !cfgMap.containsKey("repository.git.sharedCredentials")) {
                            errorCollection.addError("repository.git.authenticationType", this.i18nResolver.getText("repository.git.messages.sharedCredentialEmpty"));
                        }
                    } else if (authenticationType == GitAuthenticationType.PASSWORD) {
                        if (passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS && !cfgMap.containsKey("repository.git.passwordSharedCredentials")) {
                            errorCollection.addError("repository.git.authenticationType", this.i18nResolver.getText("repository.git.messages.sharedCredentialEmpty"));
                        } else {
                            String errorField;
                            boolean duplicatePassword;
                            boolean duplicateUsername = hasUsername && StringUtils.isNotBlank((CharSequence)uri.getUser());
                            boolean bl = duplicatePassword = hasPassword && StringUtils.isNotBlank((CharSequence)uri.getPass());
                            if (duplicateUsername || duplicatePassword) {
                                errorCollection.addError("repository.git.repositoryUrl", (duplicateUsername ? this.i18nResolver.getText("repository.git.messages.duplicateUsernameField") : "") + (duplicateUsername && duplicatePassword ? " " : "") + (duplicatePassword ? this.i18nResolver.getText("repository.git.messages.duplicatePasswordField") : ""));
                            }
                            if (duplicateUsername) {
                                errorField = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS ? "repository.git.passwordSharedCredentials" : "repository.git.username";
                                errorCollection.addError(errorField, this.i18nResolver.getText("repository.git.messages.duplicateUsernameField"));
                            }
                            if (duplicatePassword) {
                                errorField = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS ? "repository.git.passwordSharedCredentials" : "temporary.git.password.change";
                                errorCollection.addError(errorField, this.i18nResolver.getText("repository.git.messages.duplicatePasswordField"));
                            }
                            if (uri.getHost() == null && hasUsername) {
                                errorCollection.addError("repository.git.username", this.i18nResolver.getText("repository.git.messages.unsupportedUsernameField"));
                            }
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if (!hasUsername) break block18;
                    String fieldForError = passwordCredentialsSource == GitPasswordCredentialsSource.SHARED_CREDENTIALS ? "repository.git.passwordSharedCredentials" : "repository.git.username";
                    errorCollection.addError(fieldForError, this.i18nResolver.getText("repository.git.messages.unsupportedUsernameField"));
                }
            }
        }
        String key = cfgMap.get("repository.git.ssh.key");
        if (!StringUtils.isBlank((CharSequence)key) && !key.contains("-----BEGIN")) {
            errorCollection.addError("temporary.git.ssh.key.change", this.i18nResolver.getText("repository.git.messages.invalidSshKeys"));
        }
    }

    @NotNull
    public void validateForConnectionTesting(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousDefinition, @NotNull ErrorCollection errorCollection) {
        boolean changingSshKey;
        GitAuthenticationType authenticationType = this.getGitAuthenticationType(actionParametersMap);
        boolean usingSshAuth = GitAuthenticationType.SSH_KEYPAIR == authenticationType;
        boolean usingCustomSshKey = usingSshAuth && GitSshCredentialsSource.CUSTOM.name().equals(actionParametersMap.getString("repository.git.sshCredentialsSource"));
        boolean bl = changingSshKey = usingCustomSshKey && actionParametersMap.getBoolean("temporary.git.ssh.key.change");
        if (changingSshKey) {
            errorCollection.addError("temporary.git.ssh.keyfile", this.i18nResolver.getText("repository.test.connection.private.key.not.received"));
        } else {
            this.validate(actionParametersMap, previousDefinition, errorCollection);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition) {
        HashMap<String, String> cfgMap;
        block21: {
            cfgMap = new HashMap<String, String>();
            if (previousVcsLocationDefinition != null) {
                cfgMap.putAll(previousVcsLocationDefinition.getConfiguration());
            }
            cfgMap.put("repository.git.repositoryUrl", actionParametersMap.getString("repository.git.repositoryUrl"));
            cfgMap.put("repository.git.useShallowClones", Boolean.toString(actionParametersMap.getBoolean("repository.git.useShallowClones")));
            cfgMap.put("repository.git.useRemoteAgentCache", Boolean.toString(actionParametersMap.getBoolean("repository.git.useRemoteAgentCache")));
            cfgMap.put("repository.git.useSubmodules", Boolean.toString(actionParametersMap.getBoolean("repository.git.useSubmodules")));
            cfgMap.put("repository.git.commandTimeout", actionParametersMap.getString("repository.git.commandTimeout"));
            cfgMap.put("repository.git.verbose.logs", Boolean.toString(actionParametersMap.getBoolean("repository.git.verbose.logs")));
            cfgMap.put("repository.git.fetch.whole.repository", Boolean.toString(actionParametersMap.getBoolean("repository.git.fetch.whole.repository")));
            cfgMap.put("repository.git.lfs", Boolean.toString(actionParametersMap.getBoolean("repository.git.lfs")));
            String chosenAuthentication = actionParametersMap.getString("repository.git.authenticationType", GitAuthenticationType.NONE.name());
            cfgMap.put("repository.git.authenticationType", chosenAuthentication);
            switch (GitAuthenticationType.valueOf(chosenAuthentication)) {
                case NONE: {
                    cfgMap.remove("repository.git.username");
                    cfgMap.remove("repository.git.password");
                    cfgMap.remove("repository.git.ssh.key");
                    cfgMap.remove("repository.git.ssh.passphrase");
                    cfgMap.remove("repository.git.passwordCredentialsSource");
                    cfgMap.remove("repository.git.passwordSharedCredentials");
                    cfgMap.remove("repository.git.sshCredentialsSource");
                    cfgMap.remove("repository.git.sharedCredentials");
                    return cfgMap;
                }
                case PASSWORD: {
                    cfgMap.remove("repository.git.ssh.key");
                    cfgMap.remove("repository.git.ssh.passphrase");
                    cfgMap.remove("repository.git.sshCredentialsSource");
                    cfgMap.remove("repository.git.sharedCredentials");
                    String passwordCredentialsSourceString = actionParametersMap.getString("repository.git.passwordCredentialsSource");
                    cfgMap.put("repository.git.passwordCredentialsSource", passwordCredentialsSourceString);
                    switch (GitPasswordCredentialsSource.valueOf(passwordCredentialsSourceString)) {
                        case SHARED_CREDENTIALS: {
                            cfgMap.remove("repository.git.username");
                            cfgMap.remove("repository.git.password");
                            String passwordSharedCredentialsId = actionParametersMap.getString("repository.git.passwordSharedCredentials");
                            if (passwordSharedCredentialsId == null) break;
                            cfgMap.put("repository.git.sharedCredentials.deleted", Boolean.toString(!this.credentialExists(Long.parseLong(passwordSharedCredentialsId))));
                            cfgMap.put("repository.git.passwordSharedCredentials", passwordSharedCredentialsId);
                            return cfgMap;
                        }
                        case CUSTOM: {
                            cfgMap.remove("repository.git.passwordSharedCredentials");
                            cfgMap.put("repository.git.username", actionParametersMap.getString("repository.git.username"));
                            if (!actionParametersMap.getBoolean("temporary.git.password.change")) break;
                            cfgMap.put("repository.git.password", actionParametersMap.getString("temporary.git.password"));
                        }
                    }
                    return cfgMap;
                }
                case SSH_KEYPAIR: {
                    cfgMap.remove("repository.git.username");
                    cfgMap.remove("repository.git.password");
                    cfgMap.remove("repository.git.passwordCredentialsSource");
                    cfgMap.remove("repository.git.passwordSharedCredentials");
                    String sshCredentialsSourceString = actionParametersMap.getString("repository.git.sshCredentialsSource");
                    cfgMap.put("repository.git.sshCredentialsSource", sshCredentialsSourceString);
                    switch (GitSshCredentialsSource.valueOf(sshCredentialsSourceString)) {
                        case SHARED_CREDENTIALS: {
                            cfgMap.remove("repository.git.ssh.key");
                            cfgMap.remove("repository.git.ssh.passphrase");
                            String sshSharedCredentialsId = actionParametersMap.getString("repository.git.sharedCredentials");
                            if (sshSharedCredentialsId == null) return cfgMap;
                            cfgMap.put("repository.git.sharedCredentials.deleted", Boolean.toString(!this.credentialExists(Long.parseLong(sshSharedCredentialsId))));
                            cfgMap.put("repository.git.sharedCredentials", sshSharedCredentialsId);
                            break block21;
                        }
                        case CUSTOM: {
                            cfgMap.remove("repository.git.sharedCredentials");
                            if (actionParametersMap.getBoolean("temporary.git.ssh.key.change")) {
                                File keyFile = (File)actionParametersMap.getFiles().get("temporary.git.ssh.keyfile");
                                if (keyFile != null) {
                                    try {
                                        String key = FileUtils.readFileToString((File)keyFile);
                                        cfgMap.put("repository.git.ssh.key", key);
                                    }
                                    catch (IOException e) {
                                        log.error((Object)"Cannot read uploaded ssh key file", (Throwable)e);
                                    }
                                } else {
                                    cfgMap.remove("repository.git.ssh.key");
                                }
                            }
                            if (!actionParametersMap.getBoolean("temporary.git.ssh.passphrase.change")) return cfgMap;
                            cfgMap.put("repository.git.ssh.passphrase", actionParametersMap.getString("temporary.git.ssh.passphrase"));
                        }
                    }
                }
            }
        }
        return cfgMap;
    }

    private boolean credentialExists(long credentialId) {
        return this.credentialsAccessor.getCredentials(credentialId) != null;
    }

    public void addDefaultsForAdvancedOptions(Map<String, String> cfgMap) {
        cfgMap.put("repository.git.commandTimeout", Integer.toString(180));
        cfgMap.put("repository.git.useRemoteAgentCache", Boolean.TRUE.toString());
    }

    @NotNull
    public String getLocationIdentifier(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return (String)vcsLocationDefinition.getConfiguration().get("repository.git.repositoryUrl");
    }

    @NotNull
    public String getServerHost(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return "";
    }

    public Optional<VcsType> getScmType(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return Optional.of(VcsType.GIT);
    }
}

