/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.git;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.plugins.git.GitRepository;
import com.atlassian.bamboo.plugins.git.GitRepositoryAccessData;
import com.atlassian.bamboo.plugins.git.JGitOperationHelper;
import com.atlassian.bamboo.plugins.git.domain.HashAndSource;
import com.atlassian.bamboo.repository.AbstractRepository;
import com.atlassian.bamboo.repository.MavenPomAccessorAbstract;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.ssh.SshProxyService;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMavenPomAccessor
extends MavenPomAccessorAbstract<GitRepository> {
    private static final Logger log = Logger.getLogger(GitRepository.class);
    public static final String POM_XML = "pom.xml";
    private final GitRepository repository;
    private String pathToPom = "pom.xml";
    @Nullable
    private final String gitCapability;
    private final SshProxyService sshProxyService;
    private final I18nResolver i18nResolver;
    private final TrustedKeyHelper trustedKeyHelper;

    protected GitMavenPomAccessor(GitRepository repository, @NotNull SshProxyService sshProxyService, @NotNull I18nResolver i18nResolver, @Nullable String gitCapability, TrustedKeyHelper trustedKeyHelper) {
        super((AbstractRepository)repository);
        this.repository = repository;
        this.sshProxyService = sshProxyService;
        this.i18nResolver = i18nResolver;
        this.gitCapability = gitCapability;
        this.trustedKeyHelper = trustedKeyHelper;
    }

    GitMavenPomAccessor withPath(String pathToProjectRoot) {
        if (StringUtils.isNotBlank((CharSequence)pathToProjectRoot)) {
            if (pathToProjectRoot.contains("..")) {
                throw new IllegalArgumentException(this.i18nResolver.getText("repository.git.messages.invalidPomPath"));
            }
            this.pathToPom = pathToProjectRoot;
        }
        return this;
    }

    @NotNull
    public String getMavenScmProviderKey() {
        return "git";
    }

    public void parseMavenScmUrl(@NotNull String mavenScmUrl) throws IllegalArgumentException {
        this.repository.setAccessData(GitRepositoryAccessData.builder(this.repository.getAccessData()).repositoryUrl(mavenScmUrl).build());
    }

    @NotNull
    public File checkoutMavenPom(@NotNull File destinationPath) throws RepositoryException {
        File candidate;
        log.info((Object)("checkoutMavenPom to: " + destinationPath));
        JGitOperationHelper helper = new JGitOperationHelper(this.repository.getSubstitutedAccessData(), (BuildLogger)new NullBuildLogger(), this.i18nResolver, this.trustedKeyHelper);
        HashAndSource hashAndRef = helper.obtainLatestRevision();
        helper.fetch(destinationPath, hashAndRef, true);
        helper.checkout(null, destinationPath, hashAndRef.getHash(), helper.getShaOfRefIfExists(destinationPath, "HEAD"));
        File pomLocation = new File(destinationPath, this.pathToPom);
        if (pomLocation.isFile()) {
            return pomLocation;
        }
        if (pomLocation.isDirectory() && (candidate = new File(pomLocation, POM_XML)).isFile()) {
            return candidate;
        }
        throw new RepositoryException(this.i18nResolver.getText("repository.git.messages.cannotFindPom", new Serializable[]{this.pathToPom}));
    }
}

