/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.failurecache.failures;

import com.atlassian.failurecache.Cacheable;
import com.atlassian.failurecache.failures.FailureCache;
import com.atlassian.failurecache.failures.FailureEntry;
import com.atlassian.failurecache.util.date.Clock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class ExponentialBackOffFailureCache<K>
implements FailureCache<K>,
Cacheable {
    private static final int HOUR = 3600000;
    private final int initialExpiryMs;
    private final int maxExpiryMs = Integer.getInteger("navlink.failurecache.maxExpiryMs", 86400000);
    private final int backOffRate = Integer.getInteger("navlink.failurecache.backoff", 10);
    static final int maxEntries = Integer.getInteger("navlink.failurecache.maxEntries", 1000);
    private final ConcurrentMap<K, FailureEntry> cache = new ConcurrentHashMap<K, FailureEntry>();
    private final AtomicInteger checkSizeCount = new AtomicInteger(0);
    private final Clock clock;

    public ExponentialBackOffFailureCache(Clock clock) {
        this(Integer.getInteger("navlink.failurecache.initialexpiryMs", 6000), clock);
    }

    public ExponentialBackOffFailureCache(int initialExpiryMillis, Clock clock) {
        this.initialExpiryMs = initialExpiryMillis;
        this.clock = clock;
    }

    @Override
    public boolean isFailing(K key) {
        Preconditions.checkNotNull(key, (Object)"key");
        FailureEntry entry = (FailureEntry)this.cache.get(key);
        return entry != null && entry.isFailingNow(this.clock);
    }

    @Override
    public void registerSuccess(K key) {
        Preconditions.checkNotNull(key, (Object)"key");
        this.cache.remove(key);
    }

    @Override
    public void registerFailure(K key) {
        Preconditions.checkNotNull(key, (Object)"key");
        FailureEntry currentEntry = null;
        FailureEntry newEntry = null;
        do {
            if ((currentEntry = this.cache.putIfAbsent(key, FailureEntry.NULL_ENTRY)) == null) {
                currentEntry = FailureEntry.NULL_ENTRY;
            }
            if (!currentEntry.isFailingNow(this.clock)) continue;
            return;
        } while (!this.cache.replace(key, currentEntry, newEntry = this.calcNextFailureEntry(currentEntry)));
        this.cache.remove(key, FailureEntry.NULL_ENTRY);
        this.checkMaxSize();
    }

    @Override
    public int getCachePriority() {
        return 200;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
        this.checkSizeCount.set(0);
    }

    private FailureEntry calcNextFailureEntry(FailureEntry currentEntry) {
        int failureCount = currentEntry.getFailureCount();
        long expiryOffset = (long)((double)this.initialExpiryMs * Math.pow(this.backOffRate, failureCount));
        expiryOffset = Math.min(expiryOffset, (long)this.maxExpiryMs);
        return new FailureEntry(new Date(this.clock.getCurrentDate().getTime() + expiryOffset), ++failureCount);
    }

    private void checkMaxSize() {
        int count = this.checkSizeCount.incrementAndGet();
        if (count % (maxEntries / 10) != 0) {
            return;
        }
        this.checkSizeCount.set(0);
        if (this.cache.size() >= maxEntries) {
            ArrayList entries = new ArrayList(this.cache.entrySet());
            if (entries.size() < maxEntries) {
                return;
            }
            Collections.sort(entries, new Comparator<Map.Entry<K, FailureEntry>>(){

                @Override
                public int compare(Map.Entry<K, FailureEntry> o1, Map.Entry<K, FailureEntry> o2) {
                    return ComparisonChain.start().compare((Comparable)o2.getValue(), (Comparable)o1.getValue()).result();
                }
            });
            for (Map.Entry entry : entries.subList(maxEntries / 2, entries.size())) {
                this.cache.remove(entry.getKey());
            }
        }
    }
}

