package com.atlassian.application.host.i18n;

import java.io.Serializable;

import static com.atlassian.application.host.util.Arguments.checkArgumentNotNull;

/**
 * Implementation of {@link I18nResolver} using SAL.
 *
 * @since 1.0
 */
public final class SalI18nResolver implements I18nResolver
{
    private final com.atlassian.sal.api.message.I18nResolver resolver;

    /**
     * Wrap the passed {@code I18nResolver} and turn it into an {@link I18nResolver}.
     *
     * @param resolver the resolver to wrap.
     */
    public SalI18nResolver(final com.atlassian.sal.api.message.I18nResolver resolver)
    {
        this.resolver = checkArgumentNotNull(resolver, "resolver");
    }

    @Override
    public String getText(final String key)
    {
        return resolver.getText(key);
    }

    @Override
    public String getText(final String key, final Serializable... keys)
    {
        return resolver.getText(key, keys);
    }
}
