/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.confluence.blueprint;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.AbstractModulePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintBuilder;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintModuleCreator;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintPromptEntries;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintPromptEntry;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintProperties;
import com.atlassian.plugins.codegen.modules.confluence.blueprint.BlueprintStringer;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=BlueprintModuleCreator.class)
public class BlueprintPrompter
extends AbstractModulePrompter<BlueprintProperties> {
    public BlueprintPrompter(Prompter prompter) {
        super(prompter);
        this.suppressAdvancedPrompt();
    }

    @Override
    public BlueprintProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        this.showMessage("Confluence Blueprints help users create, organise and share Confluence content.\nA basic Blueprint consists of 3 plugin modules:\n\t<blueprint> - for general Blueprint configuration\n\t<content-template> - (one or more) provides content XML for the Blueprint\n\t<web-item> - displays the Blueprint in the Create dialog\nFor a Blueprint tutorial, see https://developer.atlassian.com/display/CONFDEV/Writing+a+Blueprint\nFor a Blueprint example, see https://bitbucket.org/atlassian/hello-blueprint");
        BlueprintPromptEntries props = this.promptForProps();
        return new BlueprintBuilder(props).build();
    }

    BlueprintPromptEntries promptForProps() throws PrompterException {
        BlueprintPromptEntries props = new BlueprintPromptEntries(this.getPluginKey(), this.getDefaultBasePackage());
        this.showMessage("The Blueprints will be displayed in the Create dialog via a web-item with a name, description and icon.\nThe i18n keys for the name and description will be automatically generated for your Blueprint but can be\nchanged later.");
        String blueprintName = this.promptNotBlankAndFill(BlueprintPromptEntry.WEB_ITEM_NAME_PROMPT, props);
        String defaultBlueprintDesc = "Creates pages from the " + blueprintName + " blueprint.";
        this.promptNotBlankAndFill(BlueprintPromptEntry.WEB_ITEM_DESC_PROMPT, defaultBlueprintDesc, props);
        this.showMessage("Blueprints are grouped by an Index Key that will determine the keys of the Blueprint plugin modules,\nand appear as a Label on each created Blueprint page.");
        String defaultIndexKey = blueprintName.toLowerCase().replaceAll("\\s+", "-").replaceAll("[^a-z0-9\\-]", "");
        String indexKey = this.promptNotBlankAndFill(BlueprintPromptEntry.INDEX_KEY_PROMPT, defaultIndexKey, props);
        BlueprintStringer stringer = new BlueprintStringer(indexKey, this.getPluginKey());
        this.showMessage("Blueprints Templates are in Confluence XHTML Storage format. A single Blueprint may create \nConfluence Pages based on multiple templates, so you may specify more than one template key.");
        int templateIndex = 0;
        ArrayList templateKeys = Lists.newArrayList();
        do {
            String defaultValue = stringer.makeContentTemplateKey(templateIndex);
            templateKeys.add(this.promptNotBlank(BlueprintPromptEntry.CONTENT_TEMPLATE_KEYS_PROMPT.message(), defaultValue));
            ++templateIndex;
        } while (this.promptForBoolean(BlueprintPromptEntry.ANOTHER_CONTENT_TEMPLATE_KEY_PROMPT));
        if (templateIndex > 1) {
            this.showMessage("If you added more than one Template, you'll need to provide a way for users to choose between them.\nSee the documentation on developer.atlassian.com for details on how to do this.");
        }
        props.put((Object)BlueprintPromptEntry.CONTENT_TEMPLATE_KEYS_PROMPT, (Object)templateKeys);
        this.showMessage("That's all you need to enter to create a working Blueprint! However, this SDK can create richer Blueprints\nwith How-to-Use pages, JavaScript wizards, context providers, event listeners and custom Index pages.");
        if (this.promptForBoolean(BlueprintPromptEntry.ADVANCED_BLUEPRINT_PROMPT)) {
            this.showMessage("How-to-Use pages are shown in the Create dialog when a user selects your Blueprint, and can be used to\nfamiliarise the user with what your Blueprint does and how it works. All Blueprints shipped with\nConfluence include a How-to-use page and recommend them for most Blueprints.");
            this.promptForBoolean(BlueprintPromptEntry.HOW_TO_USE_PROMPT, props);
            this.showMessage("If your Blueprint will require input from the user before creating the page or going to the Editor\nyou'll need a Dialog wizard. The Blueprints Dialog wizard config is simple to use, taking Soy\ntemplates that you provide and connecting them into a multi-page wizard that you can configure\nsimply.");
            this.promptForBoolean(BlueprintPromptEntry.DIALOG_WIZARD_PROMPT, props);
            this.showMessage("If your Blueprint will add enough content from the Wizard and/or Context Provider that the new page\ncan be saved (with a title) without the user needing to use the Editor, you can specify that \nthe Editor be skipped and the user taken directly to the page View screen. \nThis will add an attribute: create-result='view' to the Blueprint's config XML.");
            this.promptForBoolean(BlueprintPromptEntry.SKIP_PAGE_EDITOR_PROMPT, props);
            this.showMessage("If your Blueprint will add data to the page that doesn't come from the user (e.g. it comes from a \nservice that your plugin provides), you'll need to add a Context Provider to your Blueprint's template.\nContext providers allow you to add complex XHTML content to your templates, making pretty-much \nanything possible.");
            this.promptForBoolean(BlueprintPromptEntry.CONTEXT_PROVIDER_PROMPT, props);
            this.showMessage("If your Blueprint will perform actions after the Blueprint page is created, such as adding watches,\nsending emails, etc, you'll need to add an event listener.");
            this.promptForBoolean(BlueprintPromptEntry.EVENT_LISTENER_PROMPT, props);
            this.showMessage("A Blueprint Index page displays a listing of all pages in the current space that were created by that Blueprint.\nYou can override the default index page to list the Blueprint pages in any way you choose.");
            this.promptForBoolean(BlueprintPromptEntry.INDEX_PAGE_TEMPLATE_PROMPT, props);
        }
        return props;
    }

    private String promptNotBlankAndFill(BlueprintPromptEntry promptEntry, BlueprintPromptEntries props) throws PrompterException {
        return this.promptNotBlankAndFill(promptEntry, null, props);
    }

    private String promptNotBlankAndFill(BlueprintPromptEntry promptEntry, String defaultValue, BlueprintPromptEntries props) throws PrompterException {
        if (defaultValue == null) {
            defaultValue = promptEntry.defaultValue();
        }
        String input = this.promptNotBlank(promptEntry.message(), defaultValue);
        props.put((Object)promptEntry, (Object)input);
        return input;
    }

    private boolean promptForBoolean(BlueprintPromptEntry promptEntry, BlueprintPromptEntries props) throws PrompterException {
        boolean input = this.promptForBoolean(promptEntry);
        props.put((Object)promptEntry, (Object)input);
        return input;
    }

    private boolean promptForBoolean(BlueprintPromptEntry promptEntry) throws PrompterException {
        return this.promptForBoolean(promptEntry.message(), promptEntry.defaultValue());
    }

    private void showMessage(String message) throws PrompterException {
        this.prompter.showMessage("\n" + message + "\n");
    }
}

