/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter;

import com.atlassian.maven.plugins.amps.codegen.annotations.asm.ModulePrompterAnnotationParser;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompter;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompterFactory;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompterRegistry;
import com.atlassian.maven.plugins.amps.codegen.prompter.PluginModulePrompterRegistryImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.components.interactivity.Prompter;

public class PluginModulePrompterFactoryImpl
implements PluginModulePrompterFactory {
    private final PluginModulePrompterRegistry prompterRegistry = new PluginModulePrompterRegistryImpl();
    private final ModulePrompterAnnotationParser annotationParser = new ModulePrompterAnnotationParser(this.prompterRegistry);
    private String basePackage;
    private Prompter prompter;
    private Log log;

    public PluginModulePrompterFactoryImpl() throws Exception {
        this("");
    }

    public PluginModulePrompterFactoryImpl(String basePackage) throws Exception {
        this.basePackage = basePackage;
    }

    @Override
    public void scanForPrompters() throws Exception {
        this.annotationParser.setLog(this.getLog());
        this.annotationParser.setMavenPrompter(this.prompter);
        this.doParse(this.basePackage);
    }

    @Override
    public PluginModulePrompter getPrompterForCreatorClass(Class clazz) {
        return this.prompterRegistry.getPrompterForCreatorClass(clazz);
    }

    private void doParse(String packageName) throws Exception {
        if (StringUtils.isBlank((CharSequence)packageName)) {
            this.annotationParser.parse();
        } else {
            this.annotationParser.parse(packageName);
        }
    }

    @Override
    public Log getLog() {
        return this.log;
    }

    @Override
    public void setLog(Log log) {
        this.log = log;
    }
}

