/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.I18nString;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ProjectRewriter;
import com.atlassian.plugins.codegen.ResourceFile;
import com.atlassian.plugins.codegen.SourceFile;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.util.FileUtil;
import com.atlassian.plugins.codegen.util.PluginXmlHelper;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class ProjectFilesRewriter
implements ProjectRewriter {
    private PluginModuleLocation location;

    public ProjectFilesRewriter(PluginModuleLocation location) {
        this.location = (PluginModuleLocation)Preconditions.checkNotNull((Object)location, (Object)"location");
    }

    public void applyChanges(PluginProjectChangeset changes) throws Exception {
        File newFile;
        PluginXmlHelper xmlHelper = new PluginXmlHelper(this.location);
        for (SourceFile sourceFile : changes.getItems(SourceFile.class)) {
            File baseDir = sourceFile.getSourceGroup() == SourceFile.SourceGroup.TESTS ? this.location.getTestDirectory() : this.location.getSourceDirectory();
            newFile = FileUtil.dotDelimitedFilePath(baseDir, sourceFile.getClassId().getFullName(), ".java");
            Files.createParentDirs((File)newFile);
            FileUtils.writeStringToFile((File)newFile, (String)sourceFile.getContent(), (Charset)StandardCharsets.UTF_8);
        }
        for (ResourceFile resourceFile : changes.getItems(ResourceFile.class)) {
            File resourceDir = this.location.getResourcesDir();
            if (!resourceFile.getRelativePath().equals("")) {
                resourceDir = new File(resourceDir, resourceFile.getRelativePath());
            }
            newFile = new File(resourceDir, resourceFile.getName());
            Files.createParentDirs((File)newFile);
            FileUtils.writeByteArrayToFile((File)newFile, (byte[])resourceFile.getContent());
        }
        if (changes.hasItems(I18nString.class)) {
            this.addI18nStrings(FileUtil.dotDelimitedFilePath(this.location.getResourcesDir(), xmlHelper.getDefaultI18nLocation(), ".properties"), changes.getItems(I18nString.class));
        }
    }

    private void addI18nStrings(File file, Iterable<I18nString> items) throws IOException {
        Files.createParentDirs((File)file);
        String oldContent = file.exists() ? FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8) : "";
        Properties oldProps = new Properties();
        oldProps.load(new StringReader(oldContent));
        StringBuilder newContent = new StringBuilder(oldContent);
        boolean modified = false;
        for (I18nString item : items) {
            if (oldProps.containsKey(item.getName())) continue;
            if (!modified) {
                newContent.append("\n");
            }
            modified = true;
            newContent.append(item.getName()).append("=").append(item.getValue()).append("\n");
            oldProps.put(item.getName(), item.getValue());
        }
        if (modified) {
            FileUtils.writeStringToFile((File)file, (String)newContent.toString(), (Charset)StandardCharsets.UTF_8);
        }
    }
}

