/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules;

import com.atlassian.plugins.codegen.modules.PluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.PluginModuleProperties;
import com.atlassian.plugins.codegen.util.CodeTemplateHelper;
import com.atlassian.plugins.codegen.util.PluginXmlHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractPluginModuleCreator<T extends PluginModuleProperties>
implements PluginModuleCreator<T> {
    public static final String DEFAULT_I18N_NAME = "atlassian-plugin";
    public static final String FUNC_TEST_PACKAGE = "it";
    public static final String TEST_SUFFIX = "Test";
    public static final String FUNCT_TEST_SUFFIX = "FuncTest";
    public static final String GENERIC_TEMPLATE_PREFIX = "templates/generic/";
    public static final String GENERIC_TEST_TEMPLATE = "templates/generic/GenericTest.java.vtl";
    protected CodeTemplateHelper templateHelper;

    protected AbstractPluginModuleCreator() {
        this(new CodeTemplateHelper());
    }

    protected AbstractPluginModuleCreator(CodeTemplateHelper templateHelper) {
        this.templateHelper = templateHelper;
    }

    public abstract void createModule(PluginModuleLocation var1, T var2) throws Exception;

    protected void addModuleToPluginXml(String templatePath, PluginModuleLocation location, PluginModuleProperties props) throws Exception {
        PluginXmlHelper pluginXmlHelper = new PluginXmlHelper(location.getPluginXml());
        pluginXmlHelper.addModuleAsLastChild(this.templateHelper.getStringFromTemplate(templatePath, props));
        pluginXmlHelper.addI18nResource(DEFAULT_I18N_NAME);
        pluginXmlHelper.savePluginXml();
        this.createI18nProperties(location, props);
    }

    protected void addPluginInfoParamToPluginXml(PluginModuleLocation location, String name, String value) throws Exception {
        PluginXmlHelper pluginXmlHelper = new PluginXmlHelper(location.getPluginXml());
        pluginXmlHelper.addPluginInfoParam(name, value);
        pluginXmlHelper.savePluginXml();
    }

    private void createI18nProperties(PluginModuleLocation location, PluginModuleProperties props) throws Exception {
        if (location.getResourcesDir() != null && !props.getI18nProperties().isEmpty()) {
            File i18nFile = new File(location.getResourcesDir(), "atlassian-plugin.properties");
            if (!i18nFile.exists()) {
                i18nFile.createNewFile();
            }
            Properties currentProps = new Properties();
            FileInputStream is = FileUtils.openInputStream((File)i18nFile);
            currentProps.load(is);
            IOUtils.closeQuietly((InputStream)is);
            currentProps.putAll((Map<?, ?>)props.getI18nProperties());
            FileOutputStream os = FileUtils.openOutputStream((File)i18nFile);
            currentProps.store(os, "");
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    protected String testClassname(String classname) {
        return classname + TEST_SUFFIX;
    }

    protected String funcTestClassname(String classname) {
        return classname + FUNCT_TEST_SUFFIX;
    }

    protected String funcTestPackageName(String basePackage) {
        return (StringUtils.isBlank((String)basePackage) ? FUNC_TEST_PACKAGE : "it.") + basePackage;
    }
}

