/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.Media;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NestedExpandContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.stream.Stream;

@Documentation(state=Documentation.State.REVIEWED, date="2023-07-26")
public class MediaGroup
extends AbstractContentNode<MediaGroup, Media>
implements DocContent,
LayoutColumnContent,
NestedExpandContent,
NonNestableBlockContent,
TableCellContent {
    private static final String MEDIA_GROUP_PREFIX = "\ud83d\udcce ";
    static Factory<MediaGroup> FACTORY = new Factory<MediaGroup>("mediaGroup", MediaGroup.class, MediaGroup::parse);

    private MediaGroup() {
    }

    public static MediaGroup mediaGroup() {
        return new MediaGroup();
    }

    public static MediaGroup mediaGroup(Media content) {
        return (MediaGroup)MediaGroup.mediaGroup().content(content);
    }

    public static MediaGroup mediaGroup(Media ... content) {
        return (MediaGroup)MediaGroup.mediaGroup().content(content);
    }

    public static MediaGroup mediaGroup(Iterable<? extends Media> content) {
        return (MediaGroup)MediaGroup.mediaGroup().content(content);
    }

    public static MediaGroup mediaGroup(Stream<? extends Media> content) {
        return (MediaGroup)MediaGroup.mediaGroup().content(content);
    }

    @Override
    public MediaGroup copy() {
        return MediaGroup.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "mediaGroup";
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContent);
    }

    private static MediaGroup parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "mediaGroup");
        return (MediaGroup)MediaGroup.mediaGroup().parseRequiredContent(map, Media.class);
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        long count = this.content.stream().filter(media -> media.file().isPresent()).count();
        if (count == 0L) {
            return;
        }
        sb.append(MEDIA_GROUP_PREFIX).append(count).append(" File");
        if (count > 1L) {
            sb.append('s');
        }
    }
}

