/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Documentation;
import com.atlassian.adf.model.mark.Breakout;
import com.atlassian.adf.model.mark.type.ExpandMark;
import com.atlassian.adf.model.node.AbstractMarkedContentNode;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Heading;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Documentation(state=Documentation.State.UNDOCUMENTED, date="2023-07-26")
public class Expand
extends AbstractMarkedContentNode<Expand, NonNestableBlockContent, ExpandMark>
implements DocContent,
LayoutColumnContent {
    static final Factory<Expand> FACTORY = new Factory<Expand>("expand", Expand.class, Expand::parse);
    @Nullable
    private String title;

    private Expand() {
    }

    public static Expand expand() {
        return new Expand();
    }

    public static Expand expand(NonNestableBlockContent content) {
        return (Expand)Expand.expand().content(content);
    }

    public static Expand expand(NonNestableBlockContent ... content) {
        return (Expand)Expand.expand().content(content);
    }

    public static Expand expand(Iterable<? extends NonNestableBlockContent> content) {
        return (Expand)Expand.expand().content(content);
    }

    public static Expand expand(Stream<? extends NonNestableBlockContent> content) {
        return (Expand)Expand.expand().content(content);
    }

    public Optional<String> title() {
        return Optional.ofNullable(this.title);
    }

    public Expand title(String title) {
        this.title = title;
        return this;
    }

    @Override
    public Expand copy() {
        return Expand.parse(this.toMap());
    }

    @Override
    public String elementType() {
        return "expand";
    }

    @Override
    public Class<ExpandMark> markClass() {
        return ExpandMark.class;
    }

    @Override
    protected void markedContentNodeValidate() {
        this.requireNotEmpty();
    }

    @Override
    protected void validateContentNodeForAppend(NonNestableBlockContent node) {
        super.validateContentNodeForAppend(node);
        if (node instanceof Paragraph) {
            ((Paragraph)node).disableMarks(this);
        } else if (node instanceof Heading) {
            ((Heading)node).disableMarks(this);
        } else if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        }
    }

    public Optional<Breakout> breakout() {
        return this.marks.stream(Breakout.class).findAny();
    }

    public Expand breakout(@Nullable Breakout breakout) {
        this.marks.clear();
        if (breakout != null) {
            this.marks.add(breakout);
        }
        return this;
    }

    public Expand wide() {
        return this.breakout(Breakout.wide());
    }

    public Expand fullWidth() {
        return this.breakout(Breakout.fullWidth());
    }

    public Expand defaultWidth() {
        return this.breakout(null);
    }

    @Override
    protected boolean markedContentNodeEquals(Expand other) {
        return Objects.equals(this.title, other.title);
    }

    @Override
    protected int markedContentNodeHashCode() {
        return Objects.hashCode(this.title);
    }

    @Override
    protected void appendMarkedContentNodeFields(AbstractNode.ToStringHelper buf) {
        buf.appendField("title", this.title);
    }

    void disableMarks(ContentNode<?, ?> parent) {
        this.marks.disable(parent.elementType());
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContent).add("attrs", FieldMap.map().addIfPresent("title", this.title)).let(this.marks::addToMap);
    }

    private static Expand parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "expand");
        Expand expand = (Expand)new Expand().parseRequiredContent(map, NonNestableBlockContent.class);
        ParserSupport.getOrThrow(map, "attrs");
        ParserSupport.getAttr(map, "title", String.class).ifPresent(expand::title);
        return (Expand)expand.parseMarks(map);
    }
}

