# Introduction

## Highlights

* [All Your Links Are Broken](#all-your-links-are-broken)
* [Warning About "URLs" in the ADF Schmea](#warning-about--urls--in-the-adf-schema)
* [`ADFParser`: Parsing, Encoding, and Wiki Markup](#adfparser--parsing-encoding-and-wiki-markup)
* [Content-Sensitive Restrictions](#context-sensitive-restrictions)
* [Node Definitions](#node-definitions)
* [Mark Definitions](#mark-definitions)

## Schema Version 32.0.0

The latest schema file should be available at http://go.atlassian.com/adf-json-schema and
the version given above is the version it had the last time the information in this file
was updated and the library code was updated to match it. Please update the version above
and the `Schema.VERSION` value whenever the schema file, this readme, and the library
code are brought up to date with the current schema. There is a shell script accessible
as `bin/fetch-new-schema.sh` that will take care of most of this for you, but the text
descriptions in this file and the code itself have to be updated manually.

This particular file is also my attempt to present the JSON schema as a more human-readable
document. The schema uses several odd names that are hard to make sense of. This library
makes an effort to name things more consistently, and this file documents what things are
and how they correlate to the information in the schema.

## All Your Links Are Broken

Please note that the internal links within this document will not function if you are
viewing this file in Bitbucket Cloud. As a security measure, the markdown viewer in
Bitbucket Cloud will prefix all the headers it generates with `markdown-header-`, so
where `#paragraph` is the expected anchor name in this document, Bitbucket Cloud's
markdown viewer generates `#markdown-header-paragraph` for it, instead, and does not
modify the document's anchor links in a similar fashion, so they break.

It is therefore not practical to make the links work in Bitbucket Cloud and still
have them resolve properly literally anywhere else. If you are working on the source, I
suggest viewing this document directly in IntelliJ. Another option is to use the
[Markdown Viewer](https://chrome.google.com/webstore/detail/markdown-viewer/ckkdlimhmcjmikdlpkmbgfkaikojcbjk)
extension in Google Chrome. You will have to enable "Allow access to file URLs" in the
[extension's settings](chrome://extensions/?id=ckkdlimhmcjmikdlpkmbgfkaikojcbjk) for
this to work, and you should consider the possible security implications before you
do so.

## Warning About "URLs" in the ADF Schema

### What even IS a URL?

Quoting from the JavaDocs for
[URI](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/net/URI.html):

> A URI is a uniform resource *identifier* while a URL is a uniform resource *locator*.
> Hence every URL is a URI, abstractly speaking, but not every URI is a URL. This is
> because there is another subcategory of URIs, uniform resource *names* (URNs), which
> name resources but do not specify how to locate them. The `mailto`, `news`, and `isbn`
> URIs … are examples of URNs.
>
> The conceptual distinction between URIs and URLs is reflected in the differences between
> this class and the
> [URL](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/net/URL.html)
> class.
>
> An instance of this class represents a URI reference in the syntactic sense defined by
> RFC 2396. A URI may be either absolute or relative. A URI string is parsed according to
> the generic syntax without regard to the scheme, if any, that it specifies. No lookup
> of the host, if any, is performed, and no scheme-dependent stream handler is constructed.
> Equality, hashing, and comparison are defined strictly in terms of the character content
> of the instance. In other words, a URI instance is little more than a structured string
> that supports the syntactic, scheme-independent operations of comparison, normalization,
> resolution, and relativization.
>
> An instance of the
> [URL](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/net/URL.html)
> class, by contrast, represents the syntactic components of a URL together with some of the
> information required to access the resource that it describes. A URL must be absolute,
> that is, it must always specify a scheme. A URL string is parsed according to its scheme.
> A stream handler is always established for a URL, and in fact it is impossible to create a
> URL instance for a scheme for which no handler is available. Equality and hashing depend upon
> both the scheme and the Internet address of the host, if any; comparison is not defined.
> In other words, a URL is a structured string that supports the syntactic operation of
> resolution as well as the network I/O operations of looking up the host and opening a
> connection to the specified resource.

### Consequences

What does all of this mean? It means that when the ADF schema calls something a URL, it
is probably lying, because the editor generally accepts URNs for these values, too. That
means that these are not URLs; they are URIs. It is hard to come up with a good way to
reconcile all of that confusion in this library without doing something that looks strange
in Java or risks breaking compatibility with the ADF editor code. For that reason, this
library takes the following relatively lax attitude towards these values:

* The builders accept any of `String`, `URL`, or `URI` arguments for these values.
* The builders verify that `String` and `URL` arguments form valid URIs and throw an exception
  if they cannot be parsed.
* The library holds them as `String` values internally, regardless of how they are supplied.
* The parser and renderer do not validate these values, so otherwise invalid URIs will
  survive a round trip through the library, even though you can't supply such values
  yourself.
* Accessors like `url()` and operations like `fold(ifUrl, ifData)` use the raw `String`.

So if you were expecting `url()` to return a `URL`, well, now you know why it doesn't.

This same general pattern of using the string representation of values while allowing
them to also be specified using more concrete representations has been used for several
other data types as well. For example, the `date` node can accept its value as an
[Instant](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/time/Instant.html),
[Date](https://docs.oracle.com/en/java/javase/11/docs/api/java.base/java/util/Date.html),
`long` (representing millis since 1970-01-01 00:00:00 UTC), or just as a `String`.

## `ADFParser`: Parsing, Encoding, and Wiki Markup

### Definitions

This library's central class is `Doc`, which is the root of a tree describing a renderable
document. This can be an entire Confluence page, a comment, or the description on an issue
in Jira. The `Doc` class and the other concrete representations of ADF nodes and marks in
this library are mirrors of those structures described by the
[schema](http://go.atlassian.com/adf-json-schema). The library also defines an `AdfParser`
interface, which represents the ability to *marshall* the ADF content to some other form
and *unmarshall* it back to ADF. In some parts of this library, these may also be called
*encoding* and *parsing*, respectively.

The primary wire transport and storage format used for ADF content is UTF-8 encoded JSON.
In Java, this is more easily represented by its native UTF-16 strings. Small adapter
modules are provided for using one of the popular JSON libraries (Versions 1 and 2 of
the Jackson library as well as Google's GSON library) to do the heavy lifting.

### Wiki Markup

This same interface is now also surfaced by an additional module, `jira-builder-adf-wiki`,
that can render ADF to/from the classic Atlassian Wiki Markup format, instead. This code
is a port of the TypeScript `@atlaskit/editor-wikimarkup-transformer` module, which
itself has large sections ported from the Atlassian Wiki Renderer library. The TypeScript
version of the code has its own *parser* and *encoder* implementations that are tied to
the ProseMirror representation of ADF nodes. This library substitutes its own concrete
nodes in their place.

This is more of an art than a science, and there are many known problems with the
conversion code as it currently stands. ADF and Wiki Markup do not have feature parity,
and there are many edge cases where it is difficult to find the correct representation
of something or where it is outright impossible to preserve the output without
significant changes. In general, converting to or from Wiki Markup is lossy; the
content often does not reliably round-trip.

### Conversion Context

Some content items that are common to Wiki Markup and ADF have inherently incompatible
representations in their respective formats. For example, Wiki Markup references media
attachments by their original filename, but ADF instead refers to them by their Media
IDs. The two formats only contain their own information, so additional information has
to be provided to the converter for it to transform these nodes correctly. In general,
failing to provide this information does not cause the conversion to fail, but the
result will be incorrect because the Media services will not be able to locate an
attachment when given its original filename instead of its Media ID. See the `Context`
class for more about how to provide this information.

### Known Limitations, Bugs, and Feature Flags

The wiki markup conversion allows certain features to be enabled that will improve
the conversion's fidelity. These are off by default because we are still in the stage
of verifying compatibility with the Content Service's implementation, and keeping
exact feature parity (bugs and all) will be helpful in that validation. However,
once the dust settles, we have the option of enabling these features to fix known
problems in the original implementation.

Although given with their short names here, the string lookup key for the flags
use the fully qualified class name. For example, the feature flag listed here as
`LinkEncoder.USE_TITLE` uses the feature key
`com.atlassian.adf.wiki.encoder.marks.LinkEncoder.USE_TITLE`.

#### Encoder Feature Flags

* `LinkEncoder.USE_TITLE` – Links in wiki markup may optionally include a title (tooltip)
  for the link, as in `[link text|http://www.example.com|title]`. The original conversion
  ignores this field, but the `link` mark supports a `title` attribute, and this flag
  enables mapping it accordingly.
* `MediaSingleEncoder.INHERIT_LAYOUT` – The `mediaSingle` node has a mandatory `layout`
  attribute. The closest equivalent in wiki markup is providing an `align=` attribute
  for the media link, such as `!image.jpg|align=right!`. The TypeScript encoder does
  not do this, but this implementation can do it when this feature flag is enabled.
* `MediaSingleEncoder.INHERIT_LINK` – The `link` attribute can be placed on `media`
  nodes, but it can also be place on the `mediaSingle` wrapper for one. The TypeScript
  encoder drops them, but this library will use the wrapper's link if this flag is set.
* `TextEncoder.IMPROVED_ESCAPING` – The TypeScript implementation only tries to escape
  macros, mentions, and media references when encoding text nodes. Other markup, such
  as `*bold*`, is rendered without any attempt to escape it, meaning that the original
  literal meaning is often lost. Setting this flag will enable a more advanced escaper
  that uses the parser's analysis of the text to detect markup that needs to be escaped.
  This is still far from perfect. For example, it cannot detect when two separated text
  segments each individually contribute a markup character that will be matched up by
  the wiki renderer; it only operates on a single piece of text at a time. However, it
  is at least much better than the original.

#### Parser Feature Flags

* `CommonMacroParser.USE_ESCAPES` – There are three different styles of macros used in
  Wiki Markup. The original implementation does not respect the escaping conventions
  when looking for closing tags. Setting this flag will fix that.
    * `UNPAIRED` – Examples: `{anchor}` and `{loremipsum}` (neither is supported).
      They do not surround content, so no attempt is made to find a matching closing
      tag for them.
    * `PAIRED_LITERAL` – Examples: `{noformat}` and `{code}`. The first tag with no
      attributes and identical casing always matches them, so `{Code:java}` will match
      the first unescaped occurrence of `{Code}`. If it is escaped with a backslash
      character, as in `\{Code}`, then *both* the backslash *and* the tag are literal.
      It is not possible to include the matching tag sequence without a literal
      backslash before it, and it is not possible for the content to end with a literal
      backslash, either. The original parser does not respect this convention and
      always ends these macros at the first closing tag, whether it is escaped or not.
    * `PAIRED_MARKUP` - Examples: `{color}` and `{quote}`. The escaping convention is
      the same as for `{code}` and `{noformat}`, except that the normal conventions
      in wiki markup for interpreting backslashes apply. For example, since `{` is
      an escapable character, a single backslash in `\{color}` will be removed.
* `LinkTextParser.CHECK_PREV_CHAR` – The wiki renderer refuses to recognize a URL
    and turn it into a link when immediately preceded by one of the following
    characters, but the original implementation of the parser still did. This flag
    fixes that:
    * `'` or `"` – Don't mark a link if somebody put it in quotes
    * `[` or `|` – Would have been parsed under the `[text|url]` link parser syntax if
      that were what we wanted. Getting here means that it must have failed to parse
      as a link and must instead be handled as a fallback, so it should stay text.
    * `!` - Would have been parsed under the `!url!` media parser syntax if that
      were what we wanted.
* `ListBuilder.OMIT_ORDER` – On `orderedList` elements, the `order` attribute is
    optional and defaults to `1`, but the TypeScript implementation always sets
    an explicit value for it. For the sake of consistency, this code will as well,
    at least for now. But that is pointless and wasteful, and this flag suppresses
    the redundant value from the ADF output.
* `MediaParser.PARSE_ALIGN_ATTR` – The parser's side of the `align=` convention
  enabled by `MediaSingleEncoder.INHERIT_LAYOUT`.
* `UrlLinkResolver.IMPROVED_LINKS` – Enables two enhancements to how the `link` mark
  is applied to the content inside a `[content|url]` link:
    * The link can be applied to image content as well instead of only to text nodes
    * The extra copy of the original link text is only done if none of the content
      could be linked to the target. If anything is successfully linked to it (or
      found to have already been marked with the link by some other part of the
      parser code), then the extra text is not added.
* `MediaLinkResolver.OMIT_EMPTY_ATTRIBUTES` - When enabled, removes the empty `text`
  and `accessLevel` fields from mention nodes after conversion. These empty fields
  were added temporarily to mirror the behaviour of the TypeScript implementation.
* `LinkTextParser.ALLOW_EMPTY_PATH` - When enabled, links with an empty path will
  not have a trailing `/` appended to them. This is being done temporarily to mirror
  the behaviour of the TypeScript implementation.
* `TableParser.OMIT_TABLE_ATTRIBUTES` - When enabled, removes the default `table`
  attributes: `isNumberColumnEnabled = false` and `layout = default` after conversion
  (unless they are explicitly specified). These default attributes were added as a
  temporary patch to mirror the behaviour of the TypeScript transformer.

#### Known Bugs

These are problems that are known to exist and are difficult enough to solve that no
solution has yet been implemented, not even behind a feature flag. These are generally
indicated by tests that are `@Disabled` with a comment that briefly explains the
problem.

* Encoder: Macros: Unknown macros are never escaped. This is intentional, with the
  thinking being that if they aren't recognized, they will get rendered as `{macro}`
  anyway. The problem is that when the macro is unknown, the Wiki Renderer does not
  know whether the macro would have represented block or inline content and assumes it
  should be treated as a block, which is far more disruptive to the rendering. If
  the unknown macro is escaped, it is correctly displayed as ordinary inline text.
* Encoder: Text: There are contexts in which a given sequence of characters is
  absolutely impossible to encode in wiki markup. An example of this is that it
  is impossible to place the sequence `hello {code} world` in the middle of a
  `{code}` macro, because the only way to stop it from ending the code block
  prematurely is to alter the case or to put a backslash before it, and such a
  backslash would then be included literally as well. When the feature flag
  `TextEncoder.IMPROVED_ESCAPING` is enabled, we work around this by inserting
  an invisible U+2060 (WORD JOINER) character in the middle of it, and the same
  is done for that same case in `{noformat}` blocks. Probably a worse example
  involves doubled backslashes (`\\`) which are usually interpreted as a line
  break and yet still escape the character that follows. This causes all kinds
  of problems that this flag again uses a word joiner to work around.
* Parser: Media: The `!media!` link syntax is overeager and often matches things that
  it should not match, like `!?!`. This is probably because the wiki renderer uses a
  very complicated regular expression for this and the parser takes a much simpler
  approach to scanning for them.
* Parser: Marks: Does not keep scanning if an unusable closing mark is found. For
  example, `*foo * bar*` should render as **foo * bar**, with a literal asterisk
  included in the middle of bold text. However, the parser is currently confused
  by the fact that there is whitespace before that candidate stop character, does
  not find the correct stop character at the end, and renders the whole thing as
  the unmarked text: \*foo * bar*.
* Parser: Marks: There is an alternate form of most marks that allows them to be
  embedded mid-word. For example, `text *bold{*}normal` should render as
  "text **bold**normal". The form in braces should be permitted mid-word, but this
  parser is not allowing that. They are only recognized when following the same
  rules that are applied to the marks without braces. That defeats the point.
* Parser: Media: The `!media!` link syntax should generally be mapped to a
  `mediaInline` node and grouped together with `text` and other such inline nodes
  to make paragraphs. However, they are instead formed into their own groups and
  always surfaced as `mediaSingle` or `mediaGroup` block nodes instead.
* Parser: Text: There is currently no logic in the parser to reverse the word-joiner
  workarounds that are enabled via the `TextEncoder.IMPROVED_ESCAPING` flag, and
  the wiki renderer and ADF rendering will both include the word joiner in their
  respective rendered outputs, meaning that copying and pasting such segments will
  not work as expected after a round-trip or export to Data Center. The invisible
  character may also make it more difficult for users to understand what is wrong.
* Parser: URLs: The url parsing should fly over all markup characters so that things
  like `http://www.atlassian.com/test/-hyphen-/file.txt` do not get incorrectly
  interpreted as having strikethrough text in the middle of it. I have not looked
  into how hard it would be to fix that, yet.
* Parser: URLs: The URI delimeter characters that have special meaning in the URI
  syntax (like `:` and `[`) are supposed to be `%`-encoded when present in other
  parts of the URL, such as the path or query fields. However, Javascript and
  Wiki Markup both allow them to be used like this without explicitly escaping
  them. Java is stricter and will reject such a URI as invalid, causing bare links
  with that syntax not to be recognized as URIs at all.

# Context-Sensitive Restrictions

Nodes that have a `content` field only permit certain other nodes to be placed in them.
The convention used by this library is as follows:

1. Where there is only a single type of node that is permitted in the `content` section,
   no special interface is created. For example, a [table](#table) node can only contain
   [tableRow](#tablerow) nodes as `content`.
2. Where the parent node has a specialized list of permitted child nodes, this library uses
   a marker interface named after the parent node with a "Content" suffix. For example, the
   [doc](#doc) node's `content` field holds nodes marked with the [DocContent](#doccontent)
   interface.
3. Where the parent node shares the declaration of permitted content with one or more
   other parent nodes, this library uses a name derived from whatever it is called in
   the JSON schema if it makes any sense, but with a "Content" suffix. For example,
   the schema declares [paragraph](#paragraph) as containing `inline_node` items in its
   content and that content type is shared with several other node types (such as
   [heading](#heading)), so this library marks them as [InlineContent](#inlinecontent).

This same principle is applied to the `marks` field. For example, marks that may be applied
to a `text` node are marked with `TextMark`; those that may be applied to a `codeBlock`
are marked with `CodeBlockMark`. In some cases, particularly where different marks cannot
be used together, additional marker interfaces may be used that do not correspond to any
particular node type (for example, `PositionMark`) or that group them into sub-categories
within that type (for example, `CodeTextMark`).

## Mark restrictions

Text nodes can be in any of these states:

1. No marks
2. Formatted – uses one or more FormattedTextMark marks (that are not also CodeTextMark)
3. Code – uses one or more CodeTextMark marks (that are not also FormattedTextMark)
4. Indeterminate – uses one or more marks, all of which (like "annotation" and "link") are usable as either.

A text node may not combine a mark that is only in the [FormattedTextMark](#formattedtextmark) list with
one that is only in the [CodeTextMark](#codetextmark) list. Some nodes, such as [codeBlock](#codeblock),
do not allow the [text](#text) nodes in their content to have any marks at all.

### FormattedTextMark

Marks that can be combined to give the text node "formatted text inline node" characteristics:

* [annotation](#annotation)
* [em](#em)
* [link](#link)
* [strike](#strike)
* [strong](#strong)
* [subsup](#subsup)
* [textColor](#textcolor)
* [underline](#underline)

### CodeTextMark

Marks that can be combined to give the text node "code inline node" behaviour. These text
blocks are meant to be rendered using a fixed-width font and do not support most forms of
markup on that text. The marks allowed for a code inline node are:

* [annotation](#annotation)
* [code](#code)
* [link](#link)

### PositionMark

* [alignment](#alignment)
* [indentation](#indentation)

## Content restrictions

### CaptionContent

A [mediaSingle](#mediasingle) node must have a [media](#media) node as its first content item.
It may optionally also have a single [caption](#caption) node containing content from the
following types to act as the media item's caption:

* [date](#date)
* [emoji](#emoji)
* [hardBreak](#hardbreak)
* [inlineCard](#inlinecard)
* [mention](#mention)
* [placeholder](#placeholder)
* [status](#status)
* [text](#text)

### DocContent

The schema file does not assign any special name to this grouping; it just lists them all
explicitly. The original ADF documentation calls them "top-level block nodes".

* [blockCard](#blockcard)
* [blockquote](#blockquote)
* [bodiedExtension](#bodiedextension) (marks allowed)
* [bulletList](#bulletlist)
* [codeBlock](#codeblock) (with or without marks)
* [decisionList](#decisionlist)
* [embedCard](#embedcard)
* [expand](#expand) (no marks or [breakout](#breakout) mark)
* [extension](#extension) (marks allowed)
* [heading](#heading) (no marks, [alignment](#alignment) mark, or [indentation](#indentation) mark)
* [layoutSection](#layoutsection) (full)
* [mediaGroup](#mediagroup)
* [mediaSingle](#mediasingle) (with or without `caption`)
* [orderedList](#orderedlist)
* [panel](#panel)
* [paragraph](#paragraph) (no marks, [alignment](#alignment) mark, or [indentation](#indentation) mark)
* [rule](#rule)
* [table](#table)
* [taskList](#tasklist)

### InlineContent

These are used in several nodes that display text content mixed with images, emoji, and other
similar content, such as a [paragraph](#paragraph) or [taskItem](#taskitem). They can be any of
the following:

* [date](#date)
* [emoji](#emoji)
* [hardBreak](#hardbreak)
* [inlineCard](#inlinecard)
* [inlineExtension](#inlineextension) (marks allowed)
* [mediaInline](#mediainline)
* [mention](#mention)
* [placeholder](#placeholder)
* [status](#status)
* [text](#text) (with either [CodeTextMark](#codetextmark)s or [FormattedTextMark](#formattedtextmark)s, but not both)

### LayoutColumnContent

These are called "block content" in the schema and can be any of the following:

* [blockCard](#blockcard)
* [blockquote](#blockquote)
* [bodiedExtension](#bodiedextension) (marks allowed)
* [bulletList](#bulletlist)
* [codeBlock](#codeblock) (no marks)
* [decisionList](#decisionlist)
* [embedCard](#embedcard)
* [expand](#expand) (no marks)
* [extension](#extension) (marks allowed)
* [heading](#heading) (no marks | [alignment](#alignment) mark | [indentation](#indentation) mark)
* [mediaGroup](#mediagroup)
* [mediaSingle](#mediasingle) (with or without `caption`)
* [orderedList](#orderedlist)
* [panel](#panel)
* [paragraph](#paragraph) (no marks | [alignment](#alignment) mark | [indentation](#indentation) mark)
* [rule](#rule)
* [table](#table)
* [taskList](#tasklist)

### ListItemContent

Note: The [bulletList](#bulletlist) and [orderedList](#orderedlist) node types are permitted
within a [listItem](#listitem), but they cannot be the *first* `content` item in them. That is,
there must be at least one content item of some other type before them.

* [bulletList](#bulletlist) (not allowed at index 0)
* [codeBlock](#codeblock) (no marks)
* [paragraph](#paragraph) (no marks)
* [mediaSingle](#mediasingle) (with or without a [caption](#caption))
* [orderedList](#orderedlist) (not allowed at index 0)

### NestedExpandContent

* [heading](#heading) (no marks)
* [mediaGroup](#mediagroup)
* [mediaSingle](#mediasingle) (with or without a [caption](#caption))
* [paragraph](#paragraph) (no marks)

### NonNestableBlockContent

These are used in [expand](#expand) and [bodiedExtension](#bodiedextension) nodes and can be
any of the following:

* [blockCard](#blockcard)
* [blockquote](#blockquote)
* [bulletList](#bulletlist)
* [codeBlock](#codeblock) (no marks)
* [decisionList](#decisionlist)
* [embedCard](#embedcard)
* [extension](#extension) (marks allowed)
* [heading](#heading) (no marks)
* [mediaGroup](#mediagroup)
* [mediaSingle](#mediasingle) (with or without a [caption](#caption))
* [orderedList](#orderedlist)
* [panel](#panel)
* [paragraph](#paragraph) (no marks)
* [rule](#rule)
* [table](#table)
* [taskList](#tasklist)

### PanelContent

* [blockCard](#blockcard)
* [bulletList](#bulletlist)
* [heading](#heading) (no marks)
* [orderedList](#orderedlist)
* [paragraph](#paragraph) (no marks)

### TableCellContent

These are used in [tableCell](#tablecell) and [tableHeader](#tableheader) nodes and can be
any of the following:

* [blockCard](#blockcard)
* [blockquote](#blockquote)
* [bulletList](#bulletlist)
* [codeBlock](#codeblock) (no marks)
* [decisionList](#decisionlist)
* [embedCard](#embedcard)
* [extension](#extension) (marks allowed)
* [heading](#heading) (no marks)
* [mediaGroup](#mediagroup)
* [mediaSingle](#mediasingle) (with or without a [caption](#caption))
* [nestedExpand](#nestedexpand) (no marks)
* [orderedList](#orderedlist)
* [panel](#panel)
* [paragraph](#paragraph) (no marks | [alignment](#alignment) mark)  (FIXME? If [heading](#heading) can use
  the [indentation](#indentation) mark in here, why can't [paragraph](#paragraph) do that, too?)
* [rule](#rule)
* [taskList](#tasklist)

### TableRowContent

* [tableCell](#tablecell)
* [tableHeader](#tableheader)

### TaskListContent

* [taskItem](#taskitem)
* [taskList](#tasklist) (not allowed at index 0)

# Node Definitions

## blockCard

* type - `blockCard`
* attrs - must specify either `data` or `url`, but not both
    * data? - object
    * url? - string  ([URI](#what-even-is-a-url))

## blockquote

* type - `blockquote`
* content - array([paragraph](#paragraph)) (at least 1; no marks on the [paragraph](#paragraph) nodes)

## bodiedExtension

* type - `bodiedExtension`
* attrs
    * extensionKey - string
    * extensionType - string
    * layout? - `wide` | `full-width` | `default`
    * localId? - string (not empty)  (likely to be a UUID, but this is not enforced)
    * parameters? - object
    * text? - string
* content - array([NonNestableBlockContent](#nonnestableblockcontent)...) (at least 1)
* marks - array([dataConsumer](#dataconsumer)?, [fragment](#fragment)?)

## bulletList

For unordered lists, like the ones that this document uses when describing each node's fields.

* type - `bulletList`
* content - array([listItem](#listitem)...) (at least 1)

## caption

A special, optional node used by `mediaSingle` to group together the caption for the image.

* type - `caption`
* content - array([CaptionContent](#captioncontent))

## codeBlock

* type - `codeBlock`
* content - array([text](#text)...); no marks allowed on them
* marks - array([breakout](#breakout))
* attrs? – note that even though this value is optional, it is always supplied by this library for compatibility with the editor
    * language? - string

## date

* type - `date`
* attrs
    * timestamp - string (not empty)

## decisionItem

* type - `decisionItem`
* content? - array([InlineContent](#inlinecontent)...)
* attrs
    * localId - string  (likely to be a UUID, but this is not enforced)
    * state - string

## decisionList

* type - `decisionList`
* content - array([decisionItem](#decisionitem)...) (at least 1)
* attrs
    * localId - string  (likely to be a UUID, but this is not enforced)

## doc

* type - `doc`
* version - 1
* content - array([DocContent](#doccontent)...)

## embedCard

* type - `embedCard`
* attrs
    * layout - `wide` | `full-width` | `center` | `wrap-right` | `wrap-left` | `align-end` | `align-start`
    * originalHeight? - number
    * originalWidth? - number
    * url - string  ([URI](#what-even-is-a-url))
    * width? - number from `0` to `100`

## emoji

* type - `emoji`
* attrs
    * id? - string
    * shortName - string
    * text? - string

## expand

* type - `expand`
* attrs  (FIXME? Strangely, this is required whether the `title` is included or not.)
    * title? - string
* content - array([NonNestableBlockContent](#nonnestableblockcontent)...) (at least 1)
* marks? - array([breakout](#breakout))

## extension

* type - `extension`
* attrs
    * extensionKey - string (not empty)
    * extensionType - string (not empty)
    * localId? - string (not empty)  (likely to be a UUID, but this is not enforced)
    * layout? - `wide` | `full-width` | `default`
    * parameters? - object
    * text? - string
* marks? - array([dataConsumer](#dataconsumer)?, [fragment](#fragment)?)

## hardBreak

* type - `hardBreak`
* attrs?
    * text? - `\n`  (the only valid value is a string containing a literal newline char)

## heading

* type - `heading`
* content? - array([InlineContent](#inlinecontent)..,)
* attrs
    * level - int from `1` to `6`
* marks? - array([alignment](#alignment)) | array([indentation](#indentation))

## inlineCard

* type - `inlineCard`
* attrs - must specify either `data` or `url`, but not both
    * data? - object
    * url? - string  ([URI](#what-even-is-a-url))

## inlineExtension

* type - `inlineExtension`
* attrs
    * extensionKey - string (not empty)
    * extensionType - string (not empty)
    * localId? - string (not empty)  (likely to be a UUID, but this is not enforced)
    * parameters? - object
    * text? - string
* marks? - array([dataConsumer](#dataconsumer)?, [fragment](#fragment)?)

## layoutColumn

* type - `layoutColumn`
* attrs
    * width - number from `0` to `100`
* content - array([LayoutColumnContent](#layoutcolumncontent)...)

## layoutSection

* type - `layoutSection`
* content - array([layoutColumn](#layoutcolumn))
* marks? - array([breakout](#breakout))

## listItem

* type - `listItem`
* content - array([ListItemContent](#listitemcontent)...) (at least 1; [bulletList](#bulletlist) and
  [orderedList](#orderedlist) cannot be used at index 0)

## media

Note that the required `attrs` depend on the `type` attribute.

* type - `media`
* attrs (`file` or `link`)
    * type - `file` | `link`
    * alt? - string
    * collection - string
    * height? - number
    * id - string (not empty)
    * occurrenceKey? - string (not empty)
    * width? - number
* attrs (`external`)
    * type - `external`
    * alt? - string
    * height? - number
    * width? - number
    * url - string  ([URI](#what-even-is-a-url))
* marks? - array([link](#link)|[border](#border))

## mediaGroup

* type - `mediaGroup`
* content - array([media](#media)) (at least 1)

## mediaInline

* type - `mediaInline`
* attrs
    * alt? - string
    * type? - `file` | `link`
    * collection - string
    * height? - number
    * id - string (not empty)
    * occurrenceKey? - string (not empty)
    * width? - number
    * data? - object
* marks? - array([link](#link))

## mediaSingle

* type - `mediaSingle`
* content - array([media](#media), [caption](#caption)?)
* attrs?
    * width? - number from `0` to `100` when `widthType` is missing or `percentage`; non-negative integer when
      `widthType` is `pixel`
    * widthType? - `percentage` or `pixel`
    * layout - `wide` | `full-width` | `center` | `wrap-right` | `wrap-left` | `align-end` | `align-start`
* marks? - array([link](#link))

## mention

* type - `mention`
* attrs
    * accessLevel? - string  (FIXME? Original docs implied the enum `NONE` | `DEFAULT` | `APPLICATION` | `CONTAINER`,
      but the schema does not enforce this and an empty string is often used in practice. This makes no sense...)
    * id - string
    * text? - string  (must begin with `@`)
    * userType? - `DEFAULT` | `SPECIAL` | `APP`

## nestedExpand

* type - `nestedExpand`
* content - array([NestedExpandContent](#nestedexpandcontent)...)
* attrs
    * title? - string

## orderedList

Ordered lists have monotonically increasing numbers prefixed to their items, such as

1. First
2. Second
3. Third

* type - `orderedList`
* attrs?
    * order? - number (min value 0) – The number of the first item in the list
* content - array([listItem](#listitem)...) (at least 1)

## panel

* type - `panel`
* attrs
    * panelColor? - string
    * panelIcon? - string
    * panelIconId? - string
    * panelIconText? - string
    * panelType - `info` | `note` | `tip` | `warning` | `error` | `success` | `custom`
* content - array([PanelContent](#panelcontent)...)

## rule

A horizontal rule, like this:

-----

* type - `rule`

## paragraph

* type - `paragraph`
* content - array([InlineContent](#inlinecontent)...)
* marks? - array([alignment](#alignment)) | array ([indentation](#indentation))

## placeholder

* type - `placeholder`
* attrs
    * text - string (not empty)

## status

* type - `status`
* attrs
    * color - `neutral` | `purple` | `blue` | `red` | `yellow` | `green`
    * localId? - string  (likely to be a UUID, but this is not enforced)
    * style? - string
    * text - string (not empty)

## table

* type - `table`
* attrs?
    * isNumberColumnEnabled? - boolean
    * layout? - `wide` | `full-width` | `default` – the `width` attribute takes precedence
    * localId? - string (not empty)  (likely to be a UUID, but this is not enforced)
    * width? - number (expected to be an integer from 145 to 1800 representing the width in pixels, but this is not enforced)
* content - array([tableRow](#tablerow)...) (at least 1)
* marks? - array([fragment](#fragment))

## tableCell

* type - `tableCell`
* attrs? – note that even though this value is optional, it is always supplied by this library for compatibility with the editor
    * colspan? - number
    * rowspan? - number
    * colwidth? - array(number); number of entries should match `colspan` and at least 1 must be positive
    * background? - string
* content - array([TableCellContent](#tablecellcontent)...) (at least 1)

## tableHeader

* type - `tableHeader`
* attrs? – note that even though this value is optional, it is always supplied by this library for compatibility with the editor
    * colspan? - number
    * rowspan? - number
    * colwidth? - array(number)
    * background? - string
* content - array([TableCellContent](#tablecellcontent)...) (at least 1)

## tableRow

* type - `tableRow`
* content - array([TableRowContent](#tablerowcontent)...)

## taskItem

* type - `taskItem`
* content? - array([InlineContent](#inlinecontent)...)
* attrs
    * localId - string  (likely to be a UUID, but this is not enforced)
    * state - `TODO` | `DONE`

## taskList

* type - `taskList`
* content - array([TaskListContent](#tasklistcontent)) (at least 1) (cannot use [taskList](#tasklist) at index 0)
* attrs
    * localId - string  (likely to be a UUID, but this is not enforced)

## text

* type - `text`
* text - string (not empty)
* marks? - array([CodeTextMark](#codetextmark)...) | array([FormattedTextMark](#formattedtextmark)...)

# Mark Definitions

## alignment

* type - `alignment`
* attrs
    * align - `center` | `end`

## annotation

* type - `annotation`
* attrs
    * id - string
    * annotationType - `inlineComment`

## border

* type - `border`
* attrs
    * size - int (from 1 to 3)
    * color - string matching `/^#[0-9a-fA-F]{6}$/` or `/^#[0-9a-fA-F]{8}$/`; that is, a 6- or 8-digit hex color

## breakout

* type - `breakout`
* attrs
    * mode - `wide` | `full-width`

## code

For `monospace` text.

* type - `code`

## dataConsumer

* type - `dataConsumer`
* attrs
    * sources - array(string...) (at least 1)

## em

For _emphasis_ text.

* type - `em`

## fragment

* type - `fragment`
* attrs
    * localId - string (not empty)  (likely to be a UUID, but this is not enforced)
    * name? - string

## indentation

* type - `indentation`
* attrs
    * level - int from 1 to 6

## link

Marks a piece of content as hyperlinking to another location. Unlike most mark types, a `link`
can also be applied to [media](#media) and other similar node types.

* type - `link`
* attrs
    * collection? - string
    * href - string  ([URI](#what-even-is-a-url))
    * id? - string
    * occurenceKey? - string
    * title? - string

## strike

For ~~strikethrough~~ text.

* type - `strike`

## strong

For **strong** text.

* type - `strong`

## subsup

For <sup>superscript</sup> or <sub>subscript</sub> text.

* type - `subsup`
* attrs
    * type - `sub` | `sup`

## textColor

For text in a different <span style="color:#CC80FF;">color</span>.

* type - `textColor`
* attrs
    * color - string matching `/^#[0-9a-fA-F]{6}$/`

## underline

For <span style="text-decoration:underline;">underlined</span> text.

* type - `underline`

