/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class Schema {
    private static final String VERSION = "32.0.0";
    private static final int BUFFER_SIZE = 8192;
    private static final String SCHEMA_JSON = "schema.json";
    @Nullable
    private static String schema;

    private Schema() {
    }

    public static String version() {
        return VERSION;
    }

    public static URL url() {
        URL url = Schema.class.getClassLoader().getResource(SCHEMA_JSON);
        if (url == null) {
            throw new IllegalStateException("Unable to load schema: File not found");
        }
        return url;
    }

    public static InputStream inputStream() throws IOException {
        return Schema.url().openStream();
    }

    public static String schema() {
        String cached = schema;
        if (cached == null) {
            try (InputStream is = Schema.inputStream();
                 InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
                int len;
                StringWriter sw = new StringWriter();
                char[] buf = new char[8192];
                while ((len = isr.read(buf)) > 0) {
                    sw.write(buf, 0, len);
                }
                schema = cached = sw.toString();
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unable to load schema: " + ioe, ioe);
            }
        }
        return cached;
    }
}

