/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.node.ContentException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.MediaSingle;
import com.atlassian.adf.model.node.Mention;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.NodeParserSupport;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.Functions;
import com.atlassian.adf.util.ParserSupport;
import com.atlassian.annotations.Internal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractContentNode<C extends AbstractContentNode<C, N>, N extends Node>
extends AbstractNode<C>
implements ContentNode<C, N> {
    protected final List<N> content = new ArrayList<N>();

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    protected void requireNotEmpty() {
        if (this.isEmpty()) {
            throw new ContentException.ContentRequired();
        }
    }

    protected void validateContentNodeForAppend(N node) {
    }

    @Override
    public final List<N> content() {
        return Collections.unmodifiableList(this.content);
    }

    @Override
    public final C content(N content) {
        return this.content(Collections.singleton(content).iterator());
    }

    @Override
    @SafeVarargs
    public final C content(N ... content) {
        Objects.requireNonNull(content, "content");
        return this.content(Arrays.asList(content).iterator());
    }

    @Override
    public final C content(Iterable<? extends N> content) {
        Objects.requireNonNull(content, "content");
        return this.content(content.iterator());
    }

    @Override
    public final C content(Stream<? extends N> content) {
        Objects.requireNonNull(content, "content");
        return this.content(content.iterator());
    }

    @Override
    private C content(Iterator<? extends N> iter) {
        AdfException ex = null;
        int index = this.content.size();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            try {
                Objects.requireNonNull(node, "content item");
                this.validateContentNodeForAppend(node);
                this.content.add(node);
            }
            catch (AdfException e) {
                ex = AbstractContentNode.fixException(ex, e, index);
            }
            catch (RuntimeException e) {
                ex = AbstractContentNode.fixException(ex, new AdfException.UnexpectedRuntimeException(e), index);
            }
            ++index;
        }
        if (ex != null) {
            throw ex;
        }
        return (C)((AbstractContentNode)this.self());
    }

    private static AdfException fixException(@Nullable AdfException originalException, AdfException newException, int index) {
        newException.backtrace("[" + index + "]");
        if (originalException == null) {
            return newException;
        }
        originalException.addSuppressed(newException);
        return originalException;
    }

    @Override
    public Stream<Node> allNodes() {
        return Stream.concat(Stream.of(this), this.content.stream().flatMap(node -> {
            if (node instanceof ContentNode) {
                return ((ContentNode)node).allNodes();
            }
            if (node instanceof MediaSingle) {
                return ((MediaSingle)node).allNodes();
            }
            return Stream.of(node);
        }));
    }

    @Override
    public C clear() {
        this.content.clear();
        return (C)((AbstractContentNode)this.self());
    }

    @Override
    public void removeIf(Predicate<? super N> predicate) {
        ArrayList<N> newContent = new ArrayList<N>(this.content);
        if (newContent.removeIf(predicate)) {
            this.replaceContent(newContent);
        }
    }

    @Override
    public void transformContent(Function<? super N, ? extends N> transformer) {
        ArrayList<Node> newContent = new ArrayList<Node>(this.content.size());
        boolean modified = false;
        for (Node before : this.content) {
            Node after = (Node)transformer.apply(before);
            if (after != before) {
                modified = true;
            }
            if (after == null) continue;
            newContent.add(after);
        }
        if (modified) {
            this.replaceContent(newContent);
        }
    }

    @Override
    public <T extends Node> void transformDescendants(Class<T> targetNodeClass, Function<? super T, ? extends T> transformer) {
        ArrayList<Node> newContent = new ArrayList<Node>();
        boolean modified = false;
        Iterator<N> iterator = this.content.iterator();
        while (iterator.hasNext()) {
            boolean removeIt;
            Node before;
            Node after = before = (Node)iterator.next();
            if (targetNodeClass.isInstance(before) && (after = (Node)Cast.unsafeCast(transformer.apply(targetNodeClass.cast(before)))) != before) {
                modified = true;
            }
            if (after instanceof MediaSingle && (removeIt = ((MediaSingle)after).transformDescendantsInternal(targetNodeClass, transformer))) {
                after = null;
                modified = true;
            }
            if (after == null) continue;
            newContent.add(after);
            if (!(after instanceof ContentNode)) continue;
            ((ContentNode)after).transformDescendants(targetNodeClass, transformer);
        }
        if (modified) {
            this.replaceContent(newContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void replaceContent(List<? extends N> newContent) {
        ArrayList<N> backup = new ArrayList<N>(this.content);
        boolean ok = false;
        try {
            this.content.clear();
            this.content(newContent);
            ok = true;
        }
        finally {
            if (!ok) {
                this.content.clear();
                this.content.addAll(backup);
            }
        }
    }

    protected List<? extends Map<String, ?>> contentFieldMaps() {
        return Functions.mapToList(this.content, Element::toMap);
    }

    @Override
    public final void validate() {
        this.validateContentItems();
        this.contentNodeValidate();
    }

    protected void contentNodeValidate() {
    }

    protected final void validateContentItems() {
        this.content.forEach(Element::validate);
    }

    protected final void addContent(FieldMap map) {
        map.put("content", this.contentFieldMaps());
    }

    protected final void addContentIfPresent(FieldMap map) {
        if (!this.content.isEmpty()) {
            map.put("content", this.contentFieldMaps());
        }
    }

    protected int contentNodeHashCode() {
        return 0;
    }

    protected boolean contentNodeEquals(C other) {
        return true;
    }

    protected void appendContentNodeFields(AbstractNode.ToStringHelper buf) {
    }

    @Override
    protected final int nodeHashCode() {
        return this.contentNodeHashCode() * 31 + this.content.hashCode();
    }

    @Override
    protected final boolean nodeEquals(C other) {
        return this.contentNodeEquals(other) && this.content.equals(((AbstractContentNode)other).content);
    }

    @Override
    protected final void appendNodeFields(AbstractNode.ToStringHelper buf) {
        this.appendContentNodeFields(buf);
        buf.appendContentField(this.content);
    }

    protected C parseOptionalContent(Map<String, ?> map, Class<N> contentClass) {
        AbstractContentNode.getOptionalContentMaps(map).ifPresent(list -> this.parseContentItems((List<Map<String, ?>>)list, contentClass));
        return (C)((AbstractContentNode)this.self());
    }

    protected C parseRequiredContentAllowEmpty(Map<String, ?> map, Class<N> contentClass) {
        List<Map<String, ?>> list = AbstractContentNode.getRequiredContentMapsAllowEmpty(map);
        if (!list.isEmpty()) {
            this.parseContentItems(list, contentClass);
        }
        return (C)((AbstractContentNode)this.self());
    }

    protected C parseRequiredContent(Map<String, ?> map, Class<N> contentClass) {
        List<Map<String, ?>> list = AbstractContentNode.getRequiredContentMaps(map);
        this.parseContentItems(list, contentClass);
        return (C)((AbstractContentNode)this.self());
    }

    protected void parseContentItems(List<Map<String, ?>> maps, Class<N> contentClass) {
        ArrayList content = new ArrayList(maps.size());
        int i = 0;
        for (Map<String, ?> map : maps) {
            AdfException.frame("[" + i + "]", () -> content.add(this.parseContentItem(map, contentClass)));
            ++i;
        }
        this.content((Iterable)content);
    }

    protected N parseContentItem(Map<String, ?> map, Class<N> contentClass) {
        return NodeParserSupport.getNodeOfType(contentClass, map, this);
    }

    static Optional<List<Map<String, ?>>> getOptionalContentMaps(Map<String, ?> map) {
        return Optional.ofNullable((List)ParserSupport.get(map, "content"));
    }

    static List<Map<String, ?>> getRequiredContentMaps(Map<String, ?> map) {
        List list = (List)ParserSupport.get(map, "content");
        if (list == null || list.isEmpty()) {
            throw new ContentException.ContentRequired();
        }
        return list;
    }

    static List<Map<String, ?>> getRequiredContentMapsAllowEmpty(Map<String, ?> map) {
        List list = (List)ParserSupport.get(map, "content");
        if (list == null) {
            throw new ContentException.FieldRequired();
        }
        return list;
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        AbstractContentNode.appendPlainTextContent(sb, this);
    }

    static void appendPlainTextContent(StringBuilder sb, ContentNode<?, ?> contentNode) {
        contentNode.content().forEach(child -> child.appendPlainText(sb));
    }

    protected void appendPlainTextContentJoinedWith(char delimiter, StringBuilder sb) {
        Functions.iterateJoined(this.content, child -> child.appendPlainText(sb), () -> sb.append(delimiter));
    }

    protected void appendPlainTextInlineContent(StringBuilder sb) {
        int start = sb.length();
        boolean previousNodeWasMention = false;
        for (Node child : this.content) {
            int mark = sb.length();
            child.appendPlainText(sb);
            if (previousNodeWasMention && (sb.length() == mark || sb.charAt(mark) != ' ')) {
                sb.insert(mark, ' ');
            }
            previousNodeWasMention = child instanceof Mention;
        }
        this.trim(sb, start);
    }

    protected void trim(StringBuilder sb, int start) {
        int pos;
        int end = sb.length();
        for (pos = start; pos < end && sb.charAt(pos) <= ' '; ++pos) {
        }
        if (pos > start) {
            sb.delete(start, pos);
        }
        if (pos == end) {
            return;
        }
        pos = sb.length() - 1;
        if (sb.charAt(pos) > ' ') {
            return;
        }
        --pos;
        while (pos > start && sb.charAt(pos) <= ' ') {
            --pos;
        }
        sb.setLength(pos + 1);
    }
}

