package com.atlassian.adf.model.node.unsupported;

import com.atlassian.adf.model.UnsupportedElement;
import com.atlassian.adf.model.node.Node;

import java.util.Map;

import static com.atlassian.adf.util.Cast.unsafeCast;

public abstract class UnsupportedNode<N extends UnsupportedNode<N>>
        extends UnsupportedElement
        implements Node {

    UnsupportedNode(Map<String, ?> map) {
        super(map);
    }

    @Override
    public N copy() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public String toPlainText() {
        StringBuilder sb = new StringBuilder();
        appendPlainText(sb);
        return sb.toString();
    }

    @Override
    public void appendPlainText(StringBuilder sb) {
        appendPlainTextForUnsupportedNode(this, sb);
    }

    public static void appendPlainTextForUnsupportedNode(Node node, StringBuilder sb) {
        Map<String, ?> map = node.toMap();
        Object text = map.get(Node.Key.TEXT);
        if (text != null) {
            sb.append(text);
            return;
        }

        Map<String, ?> attrs = unsafeCast(map.get(Node.Key.ATTRS));
        if (attrs != null) {
            text = attrs.get(Node.Attr.TEXT);
            if (text != null) {
                sb.append(text);
                return;
            }
        }

        sb.append(plainTextFallback(node));
    }

    public static String plainTextFallback(Node node) {
        return "[" + node.elementType() + ']';
    }
}
