package com.atlassian.adf.model.node.type;

import com.atlassian.adf.model.node.Node;

/**
 * Marks the nodes that can be placed directly into a {@code doc} node.
 * These do not have their own named type in the schema, but they are also referred to as
 * "top-level block nodes" in the existing documentation.
 * <p>
 * Most doc content nodes can also be used in other locations. For example, {@code paragraph}
 * can be placed directly into a {@code Doc}, but it can also be placed inside a {@code listItem}
 * or {@code tableCell}, among several other places. Some of these other contexts may restrict
 * the node's allowed properties in some way. For example, a {@code codeBlock} can accept a
 * {@code breakout} mark when used directly in a {@code doc}, but it is not allowed to use those
 * marks when it is placed inside a {@code listItem}.
 */
public interface DocContent extends Node {
}
