package com.atlassian.adf.model.node;

import com.atlassian.adf.model.mark.Mark;
import com.atlassian.adf.model.mark.MarkParserSupport;
import com.atlassian.adf.model.node.type.Marked;
import com.atlassian.adf.util.Factory;
import com.atlassian.annotations.Internal;

import javax.annotation.Nullable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

import static com.atlassian.adf.util.Cast.unsafeCast;
import static java.util.Objects.requireNonNull;

@Internal
public abstract class AbstractMarkedNode<
        N extends AbstractMarkedNode<N, M>,
        M extends Mark
        >
        extends AbstractNode<N>
        implements Marked<N, M> {

    protected final MarkHolder<M> marks;

    AbstractMarkedNode() {
        this.marks = requireNonNull(createMarkHolder(), "createMarkHolder()");
    }

    @Override
    public final void validate() {
        marks.validate();
        markedNodeValidate();
    }

    protected void markedNodeValidate() {
    }

    @Override
    public abstract N copy();

    @Override
    public abstract Class<M> markClass();

    protected MarkHolder<M> createMarkHolder() {
        return MarkHolder.unlimited();
    }

    @Override
    public final Collection<M> marks() {
        return marks.get();
    }

    @Override
    public final Set<String> markTypes() {
        return marks.getTypes();
    }

    @Override
    public final <T extends M> Stream<? extends T> marks(Class<T> markClass) {
        return marks.stream(markClass);
    }

    @Override
    public final Optional<M> mark(String type) {
        return marks.get(type);
    }

    @Override
    public N mark(M mark) {
        marks.add(mark);
        return unsafeCast(this);
    }

    protected N parseMarks(Map<String, ?> map) {
        MarkParserSupport.parseMarks(map, markClass(), unsupportedMarkFactory(), this);
        return unsafeCast(this);
    }

    @Nullable
    protected Factory<M> unsupportedMarkFactory() {
        return null;
    }

    protected int markedNodeHashCode() {
        return 0;
    }

    protected boolean markedNodeEquals(N other) {
        return true;
    }

    protected void appendMarkedNodeFields(ToStringHelper buf) {
    }

    // These methods repeat the delegation pattern established by AbstractNode

    @Override
    protected final int nodeHashCode() {
        return markedNodeHashCode() * 31
                + marks.hashCode();
    }

    @Override
    protected final boolean nodeEquals(N other) {
        return markedNodeEquals(other)
                && marks.equals(other.marks);
    }

    @Override
    protected final void appendNodeFields(ToStringHelper buf) {
        appendMarkedNodeFields(buf);
        buf.appendMarksField(marks);
    }
}
