/**
 * Special marks that wrap opaque mark values that have an unrecognized type.
 * <p>
 * For example, if while processing a {@code text} node a mark of type {@code "foo"} is encountered,
 * then a {@link com.atlassian.adf.model.mark.unsupported.UnsupportedTextMark unsupported text mark}
 * is substituted for it. This helps preserve that content if the document structure is changed, but
 * in most other ways it is not possible to interact with these unsupported mark types.
 */
@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
package com.atlassian.adf.model.mark.unsupported;

import com.atlassian.annotations.nullability.FieldsAreNonnullByDefault;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;

import javax.annotation.ParametersAreNonnullByDefault;