package com.atlassian.adf.model.mark.type;

import com.atlassian.adf.model.mark.Mark;

/**
 * Any mark that is assignable to {@code text} nodes.
 * <p>
 * These are split into two groups, the {@link FormattedTextMark formatted-text} and {@link CodeTextMark code}
 * marks. A given text node is only allowed to use marks from one of these groups at a time, although there are
 * some marks that are marked with both interfaces and can therefore be used in either group.
 */
public interface TextMark extends Mark {
    @Override
    TextMark copy();
}
