package com.atlassian.adf.model.mark;

import com.atlassian.adf.model.Element;

/**
 * Marks are special document elements that are used to decorate {@code text} nodes.
 * They indicate that the text should be presented in a special way, such as in superscript
 * or in a different color. Most of them can be freely combined, except that:
 * <ul>
 *     <li>Only one mark of each {@link Type} is permitted. Among other things, that means it
 *     is not possible to mark text as both superscript and subscript, since both of these use
 *     the {@link Type#SUBSUP subsup} mark type.</li>
 *     <li>The {@code link} mark cannot be combined with {@code textColor}.</li>
 *     <li>The {@code link} mark is the only one that is compatible with {@code code}.</li>
 * </ul>
 */
public interface Mark extends Element {

    @Override
    Mark copy();

    /**
     * Constants used as the {@link Element.Key#TYPE type} names in marks.
     */
    interface Type {
        /**
         * @see Alignment
         */
        String ALIGNMENT = "alignment";

        /**
         * @see Annotation
         */
        String ANNOTATION = "annotation";

        /**
         * @see Border
         */
        String BORDER = "border";

        /**
         * @see Breakout
         */
        String BREAKOUT = "breakout";

        /**
         * @see Code
         */
        String CODE = "code";

        /**
         * @see DataConsumer
         */
        String DATA_CONSUMER = "dataConsumer";

        /**
         * @see Em
         */
        String EM = "em";

        /**
         * @see Fragment
         */
        String FRAGMENT = "fragment";

        /**
         * @see Indentation
         */
        String INDENTATION = "indentation";

        /**
         * @see Link
         */
        String LINK = "link";

        /**
         * @see Strike
         */
        String STRIKE = "strike";

        /**
         * @see Strong
         */
        String STRONG = "strong";

        /**
         * @see SubSup
         */
        String SUBSUP = "subsup";

        /**
         * @see TextColor
         */
        String TEXT_COLOR = "textColor";

        /**
         * @see Underline
         */
        String UNDERLINE = "underline";
    }

    /**
     * Constants used as the {@link Element.Key#ATTRS attribute} names in marks.
     */
    interface Attr extends Element.Attr {
        /**
         * Specifies how an {@link Alignment} mark alters the presentation of the containing node.
         *
         * @see Alignment.Align
         */
        String ALIGN = "align";

        /**
         * Specifies the intended meaning of an {@link Annotation} mark.
         *
         * @see Annotation.AnnotationType
         */
        String ANNOTATION_TYPE = "annotationType";

        /**
         * Provides the target URL of a {@link Link} mark.
         */
        String HREF = "href";

        /**
         * Specifies how a {@link Breakout} mark alters the presentation of the containing node.
         *
         * @see Breakout.Mode
         */
        String MODE = "mode";

        /**
         * Specifies the name of a {@link Fragment} that is associated with an {@code extension} node (or
         * similar).
         */
        String NAME = "name";

        /**
         * Specifies the data sources to associate with this {@link DataConsumer} mark.
         */
        String SOURCES = "sources";

        /**
         * Specifies the sub-type for a {@link SubSup} mark, indicating whether the marked text should
         * be displayed in <code>sup</code>erscript or <code>sub</code>script.
         *
         * @see SubSup.Type
         */
        String TYPE = "type";
    }
}
