package com.atlassian.adf.model.ex.node;

import static java.util.Objects.requireNonNull;

/**
 * Reports a problem with a {@code layoutColumn} node.
 */
public abstract class LayoutColumnException extends NodeException {
    private static final long serialVersionUID = 1L;

    LayoutColumnException(String message) {
        super(message);
    }

    /**
     * Reports an attempt to use an invalid {@code width} value on a {@code layoutColumn} node.
     */
    public static class InvalidWidth extends LayoutColumnException {
        private static final long serialVersionUID = 1L;

        public InvalidWidth(Number width) {
            super("The 'width' must be from 0.0 to 100.0: " + width);
            this.width = requireNonNull(width, "width");
        }

        private final Number width;

        public Number width() {
            return width;
        }
    }
}
