package com.atlassian.adf.model.ex.node;

import static java.util.Objects.requireNonNull;

/**
 * Reports a problem with the top-most node of an ADF document.
 */
public abstract class DocException extends NodeException {
    private static final long serialVersionUID = 1L;

    DocException(String message) {
        super(message);
    }

    /**
     * Indicates that a request to parse a document as ADF failed because the top-most node was
     * not a {@code doc}. That node type must be used for all valid ADF documents.
     */
    public static class InvalidTopLevel extends DocException {
        private static final long serialVersionUID = 1L;

        private final String type;

        public InvalidTopLevel(String type) {
            super("Invalid top-level node: expected 'doc', got '" + type + '\'');
            this.type = requireNonNull(type, "type");
        }

        public String type() {
            return type;
        }
    }

    /**
     * Indicates that the {@code doc} node specified an unsupported value for its {@code version}.
     */
    public static class UnsupportedVersion extends DocException {
        private static final long serialVersionUID = 1L;

        private final Number version;

        public UnsupportedVersion(Number version) {
            super("Unsupported version: " + version);
            this.version = requireNonNull(version, "version");
        }

        public Number version() {
            return version;
        }
    }
}
