/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.Text;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public class DecisionItem
extends AbstractContentNode<DecisionItem, InlineContent> {
    static final Factory<DecisionItem> FACTORY = new Factory<DecisionItem>("decisionItem", DecisionItem.class, DecisionItem::parse);
    private String localId;
    private String state;

    private DecisionItem(String localId, String state) {
        this.localId = Objects.requireNonNull(localId, "localId");
        this.state = Objects.requireNonNull(state, "state");
    }

    public static Partial.NeedsLocalId decisionItem() {
        return new Partial.NeedsLocalId();
    }

    @Override
    public DecisionItem copy() {
        return DecisionItem.parse(this.toMap());
    }

    @Override
    public DecisionItem content(String content) {
        return (DecisionItem)this.content(Text.text(content));
    }

    @Override
    public DecisionItem content(String ... content) {
        return (DecisionItem)this.content(Text.text(content));
    }

    public DecisionItem localId(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        return this;
    }

    public DecisionItem localId(UUID localId) {
        return this.localId(Objects.requireNonNull(localId, "localId").toString());
    }

    public String localId() {
        return this.localId;
    }

    public DecisionItem state(String state) {
        this.state = Objects.requireNonNull(state, "state");
        return this;
    }

    public String state() {
        return this.state;
    }

    @Override
    public String elementType() {
        return "decisionItem";
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().let(this::addContentIfPresent).add("attrs", FieldMap.map().add("localId", this.localId).add("state", this.state));
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        DecisionItem that = (DecisionItem)o;
        return this.localId.equals(that.localId) && this.state.equals(that.state);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.localId, this.state);
    }

    @Override
    public String toString() {
        return "DecisionItem{localId='" + this.localId + "', state='" + this.state + "', content=" + this.content + "}";
    }

    public static DecisionItem parse(Map<String, ?> map) {
        return (DecisionItem)DecisionItem.decisionItem().localId(ParserSupport.getAttrOrThrow(map, "localId", String.class)).state((String)ParserSupport.getAttrOrThrow(map, "state")).parseOptionalContent(map, InlineContent.class);
    }

    public static interface Partial {

        public static class NeedsState {
            private final String localId;

            NeedsState(String localId) {
                this.localId = Objects.requireNonNull(localId, "localId");
            }

            public DecisionItem state(String state) {
                return new DecisionItem(this.localId, state);
            }
        }

        public static class NeedsLocalId {
            NeedsLocalId() {
            }

            public NeedsState localId(String localId) {
                return new NeedsState(localId);
            }

            public NeedsState localId(UUID localId) {
                return new NeedsState(localId.toString());
            }
        }
    }
}

