/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model;

import com.atlassian.adf.model.ex.AdfException;
import java.util.Map;
import javax.annotation.Nullable;

public interface Element {
    public String elementType();

    public Map<String, ?> toMap();

    public Element copy();

    public boolean isSupported();

    public void validate();

    public static <T> T nonNull(@Nullable T value, String propertyName) {
        if (value == null) {
            throw new AdfException.MissingProperty(propertyName);
        }
        return value;
    }

    @Nullable
    public static String nullOrNonEmpty(@Nullable String value, String propertyName) {
        return value != null ? Element.nonEmpty(value, propertyName) : null;
    }

    public static String nonEmpty(String value, String propertyName) {
        Element.nonNull(value, propertyName);
        if (value.isEmpty()) {
            throw new AdfException.EmptyProperty(propertyName);
        }
        return value;
    }

    public static interface Attr {
        public static final String COLLECTION = "collection";
        public static final String COLOR = "color";
        public static final String ID = "id";
        public static final String LEVEL = "level";
        public static final String LOCAL_ID = "localId";
        public static final String OCCURRENCE_KEY = "occurrenceKey";
        public static final String TEXT = "text";
        public static final String TITLE = "title";
    }

    public static interface Key {
        public static final String ATTRS = "attrs";
        public static final String TYPE = "type";
    }
}

