/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.AdfException;
import com.atlassian.adf.model.ex.node.ContentException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.Node;
import com.atlassian.adf.model.node.NodeParserSupport;
import com.atlassian.adf.model.node.type.ContentNode;
import com.atlassian.adf.util.Cast;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

abstract class AbstractContentNode<C extends AbstractContentNode<C, N>, N extends Node>
extends AbstractNode
implements ContentNode<C, N> {
    protected final List<N> content = new ArrayList<N>();

    AbstractContentNode() {
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    protected void requireNotEmpty() {
        if (this.isEmpty()) {
            throw new ContentException.ContentRequired();
        }
    }

    protected void validateContentNodeForAppend(N node) {
    }

    @Override
    public List<N> content() {
        return Collections.unmodifiableList(this.content);
    }

    @Override
    public final C content(Stream<? extends N> content) {
        Objects.requireNonNull(content, "content");
        AdfException ex = null;
        int index = this.content.size();
        Iterator iter = content.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            try {
                Objects.requireNonNull(node, "content item");
                this.validateContentNodeForAppend(node);
                this.content.add(node);
            }
            catch (AdfException e) {
                ex = AbstractContentNode.fixException(ex, e, index);
            }
            catch (RuntimeException e) {
                ex = AbstractContentNode.fixException(ex, new AdfException.UnexpectedRuntimeException(e), index);
            }
            ++index;
        }
        if (ex != null) {
            throw ex;
        }
        return this.self();
    }

    private static AdfException fixException(@Nullable AdfException originalException, AdfException newException, int index) {
        newException.backtrace("[" + index + ']');
        if (originalException == null) {
            return newException;
        }
        originalException.addSuppressed(newException);
        return originalException;
    }

    @Override
    public Stream<Node> allNodes() {
        return Stream.concat(Stream.of(this), this.content.stream().flatMap(node -> node instanceof ContentNode ? ((ContentNode)node).allNodes() : Stream.of(node)));
    }

    @Override
    public C clear() {
        this.content.clear();
        return this.self();
    }

    @Override
    public void removeIf(Predicate<? super N> predicate) {
        ArrayList<N> newContent = new ArrayList<N>(this.content);
        if (newContent.removeIf(predicate)) {
            this.replaceContent(newContent);
        }
    }

    @Override
    public void transformContent(Function<? super N, ? extends N> transformer) {
        ArrayList<Node> newContent = new ArrayList<Node>(this.content.size());
        boolean modified = false;
        for (Node before : this.content) {
            Node after = (Node)transformer.apply(before);
            if (after != before) {
                modified = true;
            }
            if (after == null) continue;
            newContent.add(after);
        }
        if (modified) {
            this.replaceContent(newContent);
        }
    }

    @Override
    public <T extends Node> void transformDescendants(Class<T> targetNodeClass, Function<? super T, ? extends T> transformer) {
        ArrayList<Node> newContent = new ArrayList<Node>();
        boolean modified = false;
        Iterator<N> iterator = this.content.iterator();
        while (iterator.hasNext()) {
            Node before;
            Node after = before = (Node)iterator.next();
            if (targetNodeClass.isInstance(before) && (after = (Node)Cast.unsafeCast(transformer.apply(targetNodeClass.cast(before)))) != before) {
                modified = true;
            }
            if (after == null) continue;
            newContent.add(after);
            if (!(after instanceof ContentNode)) continue;
            ((ContentNode)after).transformDescendants(targetNodeClass, transformer);
        }
        if (modified) {
            this.replaceContent(newContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void replaceContent(List<? extends N> newContent) {
        ArrayList<N> backup = new ArrayList<N>(this.content);
        boolean ok = false;
        try {
            this.content.clear();
            this.content(newContent);
            ok = true;
        }
        finally {
            if (!ok) {
                this.content.clear();
                this.content.addAll(backup);
            }
        }
    }

    protected List<? extends Map<String, ?>> contentFieldMaps() {
        return this.content.stream().map(Element::toMap).collect(Collectors.toList());
    }

    @Override
    public void validate() {
        this.validateContentItems();
    }

    protected final void validateContentItems() {
        this.content.forEach(Element::validate);
    }

    protected final void addContent(FieldMap map) {
        map.put("content", this.contentFieldMaps());
    }

    protected final void addContentIfPresent(FieldMap map) {
        if (!this.content.isEmpty()) {
            map.put("content", this.contentFieldMaps());
        }
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.content.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.content, ((AbstractContentNode)o).content);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[content=" + this.content + "]";
    }

    protected final C self() {
        return (C)this;
    }

    protected C parseOptionalContent(Map<String, ?> map, Class<N> contentClass) {
        AbstractContentNode.getOptionalContentMaps(map).ifPresent(list -> this.parseContentItems((List<Map<String, ?>>)list, contentClass));
        return this.self();
    }

    protected C parseRequiredContentAllowEmpty(Map<String, ?> map, Class<N> contentClass) {
        List<Map<String, ?>> list = AbstractContentNode.getRequiredContentMapsAllowEmpty(map);
        if (!list.isEmpty()) {
            this.parseContentItems(list, contentClass);
        }
        return this.self();
    }

    protected C parseRequiredContent(Map<String, ?> map, Class<N> contentClass) {
        List<Map<String, ?>> list = AbstractContentNode.getRequiredContentMaps(map);
        this.parseContentItems(list, contentClass);
        return this.self();
    }

    protected void parseContentItems(List<Map<String, ?>> maps, Class<N> contentClass) {
        ArrayList content = new ArrayList(maps.size());
        int i = 0;
        for (Map<String, ?> map : maps) {
            AdfException.frame("[" + i + ']', () -> content.add(this.parseContentItem(map, contentClass)));
            ++i;
        }
        this.content(content);
    }

    protected N parseContentItem(Map<String, ?> map, Class<N> contentClass) {
        return NodeParserSupport.getNodeOfType(contentClass, map, this);
    }

    static Optional<List<Map<String, ?>>> getOptionalContentMaps(Map<String, ?> map) {
        return Optional.ofNullable(ParserSupport.get(map, "content"));
    }

    static List<Map<String, ?>> getRequiredContentMaps(Map<String, ?> map) {
        List list = (List)ParserSupport.get(map, "content");
        if (list == null || list.isEmpty()) {
            throw new ContentException.ContentRequired();
        }
        return list;
    }

    static List<Map<String, ?>> getRequiredContentMapsAllowEmpty(Map<String, ?> map) {
        List list = (List)ParserSupport.get(map, "content");
        if (list == null) {
            throw new ContentException.FieldRequired();
        }
        return list;
    }
}

