/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.TaskListException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.type.DocContent;
import com.atlassian.adf.model.node.type.LayoutColumnContent;
import com.atlassian.adf.model.node.type.NonNestableBlockContent;
import com.atlassian.adf.model.node.type.TableCellContent;
import com.atlassian.adf.model.node.type.TaskListContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public class TaskList
extends AbstractContentNode<TaskList, TaskListContent>
implements DocContent,
LayoutColumnContent,
NonNestableBlockContent,
TableCellContent,
TaskListContent {
    static final Factory<TaskList> FACTORY = new Factory<TaskList>("taskList", TaskList.class, TaskList::parse);
    private String localId;

    private TaskList(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
    }

    public static TaskList taskList(String localId) {
        return new TaskList(localId);
    }

    public static TaskList taskList(String localId, TaskListContent content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(String localId, TaskListContent ... content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(String localId, Iterable<? extends TaskListContent> content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public static TaskList taskList(String localId, Stream<? extends TaskListContent> content) {
        return (TaskList)TaskList.taskList(localId).content(content);
    }

    public TaskList localId(String localId) {
        this.localId = Objects.requireNonNull(localId, "localId");
        return this;
    }

    public String localId() {
        return this.localId;
    }

    @Override
    public String elementType() {
        return "taskList";
    }

    @Override
    public Map<String, ?> toMap() {
        this.requireNotEmpty();
        return this.mapWithType().let(this::addContent).add("attrs", FieldMap.map("localId", this.localId));
    }

    @Override
    public boolean equals(Object o) {
        return this == o || super.equals(o) && ((TaskList)o).localId.equals(this.localId);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.localId.hashCode();
    }

    @Override
    public String toString() {
        return "TaskList{localId='" + this.localId + "', content=" + this.content + '}';
    }

    private void validateFirstContentItemIsNotAList() {
        this.requireNotEmpty();
        TaskListContent firstContentItem = (TaskListContent)this.content.get(0);
        if (firstContentItem instanceof TaskList) {
            throw new TaskListException.CannotUseNestedTaskListAsFirstContentItem();
        }
    }

    @Override
    protected void validateContentNodeForAppend(TaskListContent node) {
        if (this.content.isEmpty() && node instanceof TaskList) {
            throw new TaskListException.CannotUseNestedTaskListAsFirstContentItem();
        }
        super.validateContentNodeForAppend(node);
    }

    @Override
    public void validate() {
        super.validate();
        this.validateFirstContentItemIsNotAList();
    }

    private static TaskList parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "taskList");
        return (TaskList)TaskList.taskList((String)ParserSupport.getAttrOrThrow(map, "localId")).parseRequiredContent(map, TaskListContent.class);
    }
}

