/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.Element;
import com.atlassian.adf.model.ex.node.MentionException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.EnumParser;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class Mention
extends AbstractNode
implements CaptionContent,
InlineContent {
    static Factory<Mention> FACTORY = new Factory<Mention>("mention", Mention.class, Mention::parse);
    private String id;
    @Nullable
    private String accessLevel;
    @Nullable
    private String text;
    @Nullable
    private UserType userType;

    private Mention(String id) {
        this.id = Mention.validateId(id);
    }

    public static Mention mention(String id) {
        return new Mention(id);
    }

    public Mention id(String id) {
        this.id = Mention.validateId(id);
        return this;
    }

    public String id() {
        return this.id;
    }

    public Optional<String> accessLevel() {
        return Optional.ofNullable(this.accessLevel);
    }

    public Mention accessLevel(@Nullable String accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    public Mention accessLevel(@Nullable AccessLevel accessLevel) {
        this.accessLevel = accessLevel != null ? accessLevel.name() : null;
        return this;
    }

    public Optional<UserType> userType() {
        return Optional.ofNullable(this.userType);
    }

    public Mention userType(@Nullable String userType) {
        return this.userType(UserType.PARSER.parseAllowNull(userType));
    }

    public Mention userType(@Nullable UserType userType) {
        this.userType = userType;
        return this;
    }

    public Optional<String> text() {
        return Optional.ofNullable(this.text);
    }

    public Mention text(@Nullable String text) {
        if (text != null && (text.isEmpty() || text.charAt(0) != '@')) {
            throw new MentionException.MentionTextMustStartWithAtSign();
        }
        this.text = text;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mention mention = (Mention)o;
        return this.userType == mention.userType && this.id.equals(mention.id) && Objects.equals(this.accessLevel, mention.accessLevel) && Objects.equals(this.text, mention.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.accessLevel, this.id, this.text, this.userType});
    }

    @Override
    public String elementType() {
        return "mention";
    }

    @Override
    public void validate() {
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().add("attrs", FieldMap.map().add("id", this.id).addIfPresent("text", this.text).addIfPresent("accessLevel", this.accessLevel).addMappedIfPresent("userType", this.userType, Enum::name));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Mention{id=").append(this.id);
        if (this.text != null) {
            sb.append(", text=").append(this.text);
        }
        if (this.accessLevel != null) {
            sb.append(", accessLevel=").append(this.accessLevel);
        }
        if (this.userType != null) {
            sb.append(", userType=").append((Object)this.userType);
        }
        return sb.append('}').toString();
    }

    private static Mention parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "mention");
        String id = (String)ParserSupport.getAttrOrThrow(map, "id");
        Mention mention = new Mention(id);
        ParserSupport.getAttr(map, "text", String.class).ifPresent(mention::text);
        ParserSupport.getAttr(map, "accessLevel", String.class).ifPresent(mention::accessLevel);
        ParserSupport.getAttr(map, "userType", String.class).ifPresent(mention::userType);
        return mention;
    }

    private static String validateId(String id) {
        Objects.requireNonNull(id, "id");
        return Element.nonEmpty(id, "id");
    }

    public static enum UserType {
        DEFAULT,
        SPECIAL,
        APP;

        static EnumParser<UserType> PARSER;

        static {
            PARSER = new EnumParser<UserType>(UserType.class, Enum::name);
        }
    }

    public static enum AccessLevel {
        NONE,
        SITE,
        APPLICATION,
        CONTAINER;

    }
}

