/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.ListException;
import com.atlassian.adf.model.node.AbstractContentNode;
import com.atlassian.adf.model.node.CodeBlock;
import com.atlassian.adf.model.node.Paragraph;
import com.atlassian.adf.model.node.type.ListItemContent;
import com.atlassian.adf.model.node.type.ListNode;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import java.util.stream.Stream;

public class ListItem
extends AbstractContentNode<ListItem, ListItemContent> {
    static Factory<ListItem> FACTORY = new Factory<ListItem>("listItem", ListItem.class, ListItem::parse);

    private ListItem() {
    }

    public static ListItem li() {
        return new ListItem();
    }

    public static ListItem li(String content) {
        return ListItem.li((ListItemContent)Paragraph.p(content));
    }

    public static ListItem li(String ... content) {
        return ListItem.li((ListItemContent)Paragraph.p(content));
    }

    public static ListItem li(ListItemContent content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem li(ListItemContent ... content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem li(Iterable<? extends ListItemContent> content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem li(Stream<? extends ListItemContent> content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem listItem() {
        return new ListItem();
    }

    public static ListItem listItem(String content) {
        return ListItem.li((ListItemContent)Paragraph.p(content));
    }

    public static ListItem listItem(String ... content) {
        return ListItem.li((ListItemContent)Paragraph.p(content));
    }

    public static ListItem listItem(ListItemContent content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem listItem(ListItemContent ... content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem listItem(Iterable<? extends ListItemContent> content) {
        return (ListItem)ListItem.li().content(content);
    }

    public static ListItem listItem(Stream<? extends ListItemContent> content) {
        return (ListItem)ListItem.li().content(content);
    }

    @Override
    public String elementType() {
        return "listItem";
    }

    @Override
    public void validate() {
        super.validate();
        this.validateFirstContentItemIsNotAList();
    }

    private void validateFirstContentItemIsNotAList() {
        this.requireNotEmpty();
        ListItemContent firstContentItem = (ListItemContent)this.content.get(0);
        if (firstContentItem instanceof ListNode) {
            throw new ListException.CannotUseNestedListAsFirstContentItem();
        }
    }

    @Override
    public Map<String, ?> toMap() {
        this.validateFirstContentItemIsNotAList();
        return this.mapWithType().let(this::addContent);
    }

    @Override
    protected void validateContentNodeForAppend(ListItemContent node) {
        super.validateContentNodeForAppend(node);
        if (node instanceof Paragraph) {
            ((Paragraph)node).disableMarks(this);
        } else if (node instanceof CodeBlock) {
            ((CodeBlock)node).disableMarks(this);
        } else if (node instanceof ListNode && this.content.isEmpty()) {
            throw new ListException.CannotUseNestedListAsFirstContentItem();
        }
    }

    private static ListItem parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "listItem");
        return (ListItem)ListItem.li().parseRequiredContent(map, ListItemContent.class);
    }
}

