/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.adf.model.node;

import com.atlassian.adf.model.ex.node.HardBreakException;
import com.atlassian.adf.model.node.AbstractNode;
import com.atlassian.adf.model.node.type.CaptionContent;
import com.atlassian.adf.model.node.type.InlineContent;
import com.atlassian.adf.util.Factory;
import com.atlassian.adf.util.FieldMap;
import com.atlassian.adf.util.ParserSupport;
import java.util.Map;
import javax.annotation.Nullable;

public class HardBreak
extends AbstractNode
implements CaptionContent,
InlineContent {
    static Factory<HardBreak> FACTORY = new Factory<HardBreak>("hardBreak", HardBreak.class, HardBreak::parse);
    private static final String NEWLINE = "\n";
    private static final HardBreak WITH_TEXT = new HardBreak(true);
    private static final HardBreak WITHOUT_TEXT = new HardBreak(false);
    private final boolean hasText;

    public static HardBreak hardBreakWithText() {
        return WITH_TEXT;
    }

    public static HardBreak hardBreak() {
        return WITHOUT_TEXT;
    }

    public static HardBreak br() {
        return WITHOUT_TEXT;
    }

    public boolean hasText() {
        return this.hasText;
    }

    private HardBreak(boolean hasText) {
        this.hasText = hasText;
    }

    @Override
    public String elementType() {
        return "hardBreak";
    }

    @Override
    public void validate() {
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj;
    }

    @Override
    public String toString() {
        return "HardBreak{hasText=" + this.hasText + '}';
    }

    @Override
    public Map<String, ?> toMap() {
        return this.mapWithType().addIf(this.hasText, "attrs", () -> FieldMap.map("text", NEWLINE));
    }

    private static HardBreak parse(Map<String, ?> map) {
        ParserSupport.checkType(map, "hardBreak");
        String text = ParserSupport.getAttr(map, "text", String.class).orElse(null);
        if (text == null) {
            return HardBreak.br();
        }
        if (NEWLINE.equals(text)) {
            return HardBreak.hardBreakWithText();
        }
        throw new HardBreakException.TextMustBeNewline();
    }
}

